/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.view.history;

import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.model.history.HistoryTableModel;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.BooleanArrayRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.BooleanRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.DateRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.RunnableRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.view.dialogs.StartBuildDialog;
import at.jku.ssw.mevss.cerberus.ci.client.view.main.CerberusCloseableTabbedPane;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableRowSorter;

public class HistoryView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Logger LOGGER = Logger.getLogger(this.getClass().getSimpleName());
    JTable table;

    public HistoryView(RemoteProjectAccess data, CerberusCloseableTabbedPane tab) throws RemoteException {
        this.createHistory(data, tab);
    }

    private void createHistory(RemoteProjectAccess data, CerberusCloseableTabbedPane tab) throws RemoteException {
        this.LOGGER.fine("setting up UI - History");
        HistoryTableModel model = new HistoryTableModel(data, id -> tab.openTestDetails(data, (BuildID)id, null), id -> new StartBuildDialog(data, id.toEnv(), null, null, false));
        this.table = new JTable();
        this.table.setModel(model);
        this.table.setSelectionMode(0);
        TableRowSorter<HistoryTableModel> sorter = new TableRowSorter<HistoryTableModel>(model);
        sorter.setSortsOnUpdates(true);
        this.table.setRowSorter(sorter);
        this.table.setDefaultRenderer(Date.class, new DateRenderer());
        this.table.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        this.table.setDefaultRenderer(Boolean[].class, new BooleanArrayRenderer());
        this.table.setDefaultRenderer(Runnable.class, RunnableRenderer.INSTANCE);
        this.table.setDefaultEditor(Runnable.class, RunnableRenderer.INSTANCE);
        this.table.setTableHeader(new JTableHeader(this.table.getColumnModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                return this.table.getModel().getColumnName(index);
            }
        });
        JScrollPane scroller = new JScrollPane(this.table);
        JPanel control = new JPanel(new BorderLayout());
        control.add("Center", new JLabel());
        this.setLayout(new BorderLayout());
        this.add((Component)scroller, "Center");
        this.add((Component)control, "South");
    }

    public void onOpen() {
        this.table.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.DESCENDING), new RowSorter.SortKey(2, SortOrder.ASCENDING), new RowSorter.SortKey(3, SortOrder.ASCENDING), new RowSorter.SortKey(4, SortOrder.ASCENDING)));
    }
}

