/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.view.dialogs;

import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class StartBuildDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final Logger LOGGER = Logger.getLogger(this.getClass().getSimpleName());
    private final RemoteProjectAccess data;
    private final BuildID env;
    private final String[] testNames;
    private final String[] performanceTestNames;
    private final boolean deploy;
    private final BuildID[] availableEnvs;
    private final String[] availableFunctionalTests;
    private final String[] availablePerformanceTests;

    public StartBuildDialog(RemoteProjectAccess data, BuildID env, String[] testNames, String[] performanceTestNames, boolean deploy) {
        this.data = data;
        this.env = env;
        this.testNames = testNames;
        this.performanceTestNames = performanceTestNames;
        this.deploy = deploy;
        this.availableEnvs = data.getEnvironments();
        this.availableFunctionalTests = data.getFunctionalTests();
        this.availablePerformanceTests = data.getPerformanceTests();
        this.buildStartBuildDialog();
    }

    private void buildStartBuildDialog() {
        this.LOGGER.fine("Start building \"Start build\" dialog");
        this.setTitle("Start Manual Build");
        this.setLocation(150, 150);
        JPanel environmentsPanel = new JPanel();
        HashMap<BuildID, JCheckBox> environmentsCheckBoxes = new HashMap<BuildID, JCheckBox>();
        this.buildEnvironmentsPanel(environmentsPanel, environmentsCheckBoxes);
        JPanel testsPanel = new JPanel();
        HashMap<String, JCheckBox> testsCheckBoxes = new HashMap<String, JCheckBox>();
        this.buildTestsPanel(testsPanel, testsCheckBoxes);
        JPanel performanceTestsPanel = new JPanel();
        HashMap<String, JCheckBox> performanceTestsCheckBoxes = new HashMap<String, JCheckBox>();
        this.buildPerformanceTestsPanel(performanceTestsPanel, performanceTestsCheckBoxes);
        JPanel deployPanel = new JPanel();
        deployPanel.setLayout(new BoxLayout(deployPanel, 1));
        JCheckBox deployBox = new JCheckBox();
        deployBox.setSelected(this.deploy);
        JLabel deployLabel = new JLabel("Deploy");
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        p.add(deployBox);
        p.add(deployLabel);
        p.setAlignmentX(0.0f);
        deployPanel.add(p);
        JTextField buildNameTextField = new JTextField("manual (" + System.getProperty("user.name") + ")");
        JButton startButton = new JButton("Start");
        startButton.addActionListener(__ -> this.dispose());
        startButton.addActionListener(__ -> this.data.startBuild(buildNameTextField.getText(), this.getBuildsToBuild(environmentsCheckBoxes), this.getActionsToExecute(testsCheckBoxes, performanceTestsCheckBoxes), deployBox.isSelected()));
        Runnable resetStart = () -> startButton.setEnabled(environmentsCheckBoxes.values().stream().map(box -> box.isSelected()).reduce(false, (b1, b2) -> b1 != false || b2 != false));
        environmentsCheckBoxes.values().stream().forEach(box -> box.addActionListener(e -> resetStart.run()));
        resetStart.run();
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> this.dispose());
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(startButton);
        buttons.add(cancelButton);
        JPanel controlPanel = new JPanel(new BorderLayout());
        controlPanel.setBorder(new TitledBorder("Control"));
        controlPanel.add((Component)buildNameTextField, "Center");
        controlPanel.add((Component)buttons, "East");
        JPanel insidePanel = new JPanel();
        insidePanel.setLayout(new BoxLayout(insidePanel, 1));
        insidePanel.add(environmentsPanel);
        insidePanel.add(testsPanel);
        insidePanel.add(performanceTestsPanel);
        if (this.deploy) {
            insidePanel.add(deployPanel);
        }
        JScrollPane scrollPane = new JScrollPane(insidePanel);
        scrollPane.setHorizontalScrollBarPolicy(30);
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BoxLayout(containerPanel, 1));
        containerPanel.add(scrollPane);
        containerPanel.add(controlPanel);
        this.getContentPane().add(containerPanel);
        this.pack();
        this.setVisible(true);
    }

    private void buildEnvironmentsPanel(JPanel environmentsPanel, Map<BuildID, JCheckBox> envBoxes) {
        environmentsPanel.setLayout(new BoxLayout(environmentsPanel, 1));
        environmentsPanel.setBorder(new TitledBorder("Environments"));
        for (int i = 0; i < this.availableEnvs.length; ++i) {
            int index = i;
            BuildID e = this.availableEnvs[index];
            JCheckBox box = new JCheckBox();
            envBoxes.put(e, box);
            box.setSelected(this.env == null || this.env.equals(e));
            JLabel label = new JLabel(e.toString());
            environmentsPanel.add(label);
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(0));
            p.add(box);
            p.add(label);
            p.setAlignmentX(0.0f);
            environmentsPanel.add(p);
        }
    }

    private void buildTestsPanel(JPanel testsPanel, Map<String, JCheckBox> testBoxes) {
        testsPanel.setLayout(new BoxLayout(testsPanel, 1));
        testsPanel.setBorder(new TitledBorder("Functional tests"));
        for (int i = 0; i < this.availableFunctionalTests.length; ++i) {
            int index = i;
            String test = this.availableFunctionalTests[index];
            JCheckBox box = new JCheckBox();
            testBoxes.put(test, box);
            box.setSelected(this.testNames == null || ArraysUtil.contains(this.testNames, test));
            JLabel label = new JLabel(test);
            testsPanel.add(label);
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(0));
            p.add(box);
            p.add(label);
            p.setAlignmentX(0.0f);
            testsPanel.add(p);
        }
    }

    private void buildPerformanceTestsPanel(JPanel performanceTestsPanel, Map<String, JCheckBox> performanceTestBoxes) {
        performanceTestsPanel.setLayout(new BoxLayout(performanceTestsPanel, 1));
        performanceTestsPanel.setBorder(new TitledBorder("Performance tests"));
        for (int i = 0; i < this.availablePerformanceTests.length; ++i) {
            int index = i;
            String performanceTestName = this.availablePerformanceTests[index];
            JCheckBox box = new JCheckBox();
            box.setSelected(this.performanceTestNames == null || ArraysUtil.contains(this.performanceTestNames, performanceTestName));
            performanceTestBoxes.put(performanceTestName, box);
            JLabel label = new JLabel(performanceTestName);
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(0));
            p.add(box);
            p.add(label);
            p.setAlignmentX(0.0f);
            performanceTestsPanel.add(p);
        }
    }

    private BuildID[] getBuildsToBuild(Map<BuildID, JCheckBox> environmentsCheckBoxes) {
        return (BuildID[])environmentsCheckBoxes.entrySet().stream().filter(e -> ((JCheckBox)e.getValue()).isSelected()).map(e -> (BuildID)e.getKey()).toArray(BuildID[]::new);
    }

    private String[] getActionsToExecute(Map<String, JCheckBox> testsCheckBoxes, Map<String, JCheckBox> performanceTestsCheckBoxes) {
        Stream<String> testsToExecute = testsCheckBoxes.entrySet().stream().filter(entry -> ((JCheckBox)entry.getValue()).isSelected()).map(entry -> (String)entry.getKey());
        Stream<String> performanceTestsToExecute = performanceTestsCheckBoxes.entrySet().stream().filter(e -> ((JCheckBox)e.getValue()).isSelected()).map(e -> (String)e.getKey());
        return (String[])Stream.of(testsToExecute, performanceTestsToExecute).flatMap(x -> x).toArray(String[]::new);
    }
}

