/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.view.details;

import at.jku.ssw.mevss.cerberus.ci.client.BlamingHelper;
import at.jku.ssw.mevss.cerberus.ci.client.LogWriter;
import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.data.SafeRemoteMap;
import at.jku.ssw.mevss.cerberus.ci.client.filechooser.JFileChooserUtil;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.BooleanRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.util.JCloseableTabbedPane;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.Closeable;
import java.io.FileWriter;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

public class BuildDetailsView
extends JPanel {
    private static final long serialVersionUID = 1L;
    Logger LOGGER = Logger.getLogger(this.getClass().getSimpleName());

    public BuildDetailsView(JCloseableTabbedPane tabs, RemoteProjectAccess data, BuildID id, List<Closeable> closeables) {
        this.createDetailsBuild(tabs, data, id, closeables);
    }

    private void createDetailsBuild(JCloseableTabbedPane tabs, RemoteProjectAccess data, final BuildID id, List<Closeable> closeables) {
        this.LOGGER.finer("creating UI - Details for " + id + " - Builds");
        this.LOGGER.finest("creating UI - Details for " + id + " - Builds (View)");
        JLabel description = new JLabel();
        JButton blame = new JButton("Blame (silently)");
        JPanel status = new JPanel(new FlowLayout(2));
        status.add(description);
        status.add(blame);
        JTextArea log = new JTextArea();
        log.setEditable(false);
        JScrollPane scroller = new JScrollPane(log);
        scroller.setBorder(new TitledBorder("Log"));
        JButton saveLog = new JButton("Save log");
        JButton saveBuild = new JButton("Save build");
        JPanel control = new JPanel();
        control.setLayout(new FlowLayout(2));
        control.add(saveLog);
        control.add(saveBuild);
        this.setLayout(new BorderLayout());
        this.add((Component)status, "North");
        this.add((Component)scroller, "Center");
        this.add((Component)control, "South");
        this.LOGGER.finest("creating UI - Details for " + id + " - Builds (Controller)");
        saveLog.addActionListener(e -> BuildDetailsView.saveBuildLog(log, data, id));
        saveBuild.addActionListener(e -> BuildDetailsView.saveBuild(log, data, id));
        blame.addActionListener(e -> {
            blame.setEnabled(false);
            data.buildAccess.startBlame(id, null, report -> SwingUtilities.invokeLater(() -> {
                blame.setEnabled(true);
                BlamingHelper.openBlameReport(tabs, data, id, report);
            }));
        });
        RemoteProjectAccess.LogListener logListener = line -> SwingUtilities.invokeLater(() -> log.append(line + "\n"));
        Runnable logRunnable = () -> data.buildAccess.getLog(id, null, logListener, false, true);
        Thread worker = new Thread(logRunnable, "BuildDetails Log Worker");
        worker.setDaemon(true);
        final Runnable reset = () -> {
            Boolean result = ((BuildInfo)data.getValue(id)).getBuildResult();
            saveLog.setEnabled(result != null);
            saveBuild.setEnabled(result != null && result != false);
            blame.setEnabled(result != null && result == false);
            String descriptionText = result != null ? (result.booleanValue() ? "Build successful" : "Build failed") : "Build in progress";
            description.setText(descriptionText);
            status.setBorder(new MatteBorder(10, 10, 10, 10, BooleanRenderer.getColor(result)));
        };
        SafeRemoteMap.Listener<BuildID> listener = new SafeRemoteMap.Listener<BuildID>(){

            @Override
            public void added(BuildID __) {
            }

            @Override
            public void removed(BuildID __) {
            }

            @Override
            public void changed(BuildID key) {
                if (id.equals(key)) {
                    reset.run();
                }
            }

            @Override
            public void closed() {
            }
        };
        data.addListener(listener);
        closeables.add(() -> data.removeListener(listener));
        closeables.add(() -> worker.interrupt());
        this.LOGGER.finest("creating UI - Details for " + id + " - Builds (Controller initializing)");
        reset.run();
        worker.start();
    }

    private static void saveBuildLog(Component parent, RemoteProjectAccess data, BuildID id) {
        JFileChooserUtil.chooseFileAndSave(parent, false, JFileChooserUtil.generatePath(data.getName(), id.toIdSortedString(), "build", null, ".log"), log -> {
            try (LogWriter out = new LogWriter(new FileWriter(log));){
                data.buildAccess.getLog(id, null, out, true, false);
            }
        });
    }

    private static void saveBuild(Component parent, RemoteProjectAccess data, BuildID id) {
        JFileChooserUtil.chooseFileAndSave(parent, true, JFileChooserUtil.generatePath(data.getName(), id.toIdSortedString(), "build", null, null), dir -> data.buildAccess.getDirectory(id, null, dir, new String[0]));
    }
}

