/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.view.details;

import at.jku.ssw.mevss.cerberus.ci.client.BlamingHelper;
import at.jku.ssw.mevss.cerberus.ci.client.LogWriter;
import at.jku.ssw.mevss.cerberus.ci.client.TestResult;
import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.data.SafeRemoteMap;
import at.jku.ssw.mevss.cerberus.ci.client.errors.Errors;
import at.jku.ssw.mevss.cerberus.ci.client.filechooser.JFileChooserUtil;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.ActionNamesTableModel;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.ActionResults;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.ActionResultsTableModel;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.ExecutionResult;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.MetricResults;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.MetricsNameTableModel;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.MetricsResultsTableModel;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.ParameterComboBoxModel;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.Average;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.BooleanArrayRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.BooleanRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.DateRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.ExecutionResultArrayRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.NumberRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.RunnableRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.util.JCloseableTabbedPane;
import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.table.JTableHeader;

public class ActionDetailsView
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private Logger LOGGER = Logger.getLogger(this.getClass().getSimpleName());
    private final RemoteProjectAccess projectAccess;
    private RemoteProjectAccess.CapabilityAccess capabilityAccess = null;
    private String actionType = "";
    private String predicate = "";
    private final String saveMetricText = "Save metric";
    private final Capability responsibility;
    JTable actionNameTable;

    public ActionDetailsView(JCloseableTabbedPane tabs, RemoteProjectAccess data, BuildID id, String test, List<Closeable> closeables, Capability responsibility) {
        this.projectAccess = data;
        this.responsibility = responsibility;
        switch (responsibility) {
            case FUNCTIONAL_TEST: {
                this.capabilityAccess = data.testAccess;
                this.actionType = "test";
                this.predicate = "Test";
                break;
            }
            case PERFORMANCE_TEST: {
                this.capabilityAccess = data.performanceAccess;
                this.actionType = "performance";
                this.predicate = "Performance Tests";
                break;
            }
            default: {
                this.capabilityAccess = null;
                this.actionType = "";
            }
        }
        this.createActionDetails(tabs, id, test, closeables);
    }

    public void setTest(String testname) {
        for (int i = 0; i < this.actionNameTable.getRowCount(); ++i) {
            if (!this.actionNameTable.getValueAt(i, 0).toString().equals(testname)) continue;
            this.actionNameTable.setRowSelectionInterval(i, i);
            break;
        }
    }

    private void createActionDetails(JCloseableTabbedPane tabs, final BuildID id, String test, List<Closeable> closeables) {
        this.LOGGER.finer("creating UI - Details for " + id + " - " + this.predicate);
        this.LOGGER.finest("creating UI - Details for " + id + " - " + this.predicate + " (Model)");
        ActionNamesTableModel actionNamesTableModel = new ActionNamesTableModel(this.projectAccess, id, this.responsibility);
        ActionResultsTableModel actionResultsModel = new ActionResultsTableModel(this.capabilityAccess, id);
        MetricsNameTableModel metricsNameModel = new MetricsNameTableModel(this.capabilityAccess, id);
        final MetricsResultsTableModel metricsResultsModel = new MetricsResultsTableModel(this.capabilityAccess, id);
        ParameterComboBoxModel parameterComboBoxModel = new ParameterComboBoxModel(actionResultsModel);
        this.LOGGER.finest("creating UI - Details for " + id + " - " + this.predicate + " (View)");
        this.actionNameTable = new JTable();
        this.actionNameTable.setModel(actionNamesTableModel);
        this.actionNameTable.setSelectionMode(0);
        this.actionNameTable.setAutoCreateRowSorter(true);
        this.actionNameTable.setDefaultRenderer(Date.class, new DateRenderer());
        this.actionNameTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        this.actionNameTable.setDefaultRenderer(Boolean[].class, new BooleanArrayRenderer());
        this.actionNameTable.setDefaultRenderer(Runnable.class, RunnableRenderer.INSTANCE);
        this.actionNameTable.setDefaultEditor(Runnable.class, RunnableRenderer.INSTANCE);
        this.actionNameTable.setTableHeader(new JTableHeader(this.actionNameTable.getColumnModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                return ActionDetailsView.this.actionNameTable.getModel().getColumnName(index);
            }
        });
        JScrollPane testsScroller = new JScrollPane(this.actionNameTable);
        testsScroller.setMinimumSize(new Dimension(250, 250));
        JLabel description = new JLabel();
        JButton blame = new JButton("Blame (silently)");
        JPanel status = new JPanel(new FlowLayout(2));
        status.add(description);
        status.add(blame);
        JTextArea log = new JTextArea();
        log.setEditable(false);
        JScrollPane logScroller = new JScrollPane(log);
        final JTable testResults = new JTable();
        testResults.setModel(actionResultsModel);
        testResults.setSelectionMode(0);
        testResults.setAutoCreateRowSorter(true);
        testResults.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        testResults.setDefaultRenderer(Boolean[].class, new BooleanArrayRenderer());
        final ExecutionResultArrayRenderer testResultRenderer = new ExecutionResultArrayRenderer();
        testResults.setDefaultRenderer(ExecutionResult[].class, testResultRenderer);
        testResults.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        testResults.setComponentPopupMenu(new JPopupMenu(){
            {
                JMenuItem switchView = new JMenuItem("Switch result view type");
                this.add(switchView);
                switchView.addActionListener(e -> {
                    testResultRenderer.switchMode();
                    ActionDetailsView.this.revalidate();
                    ActionDetailsView.this.repaint();
                });
            }
        });
        testResults.setTableHeader(new JTableHeader(testResults.getColumnModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                return testResults.getModel().getColumnName(index);
            }
        });
        JScrollPane testResultsScroller = new JScrollPane(testResults);
        final JTable metrics = new JTable();
        metrics.setModel(metricsNameModel);
        metrics.setSelectionMode(0);
        metrics.setAutoCreateRowSorter(true);
        metrics.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        metrics.setDefaultRenderer(Boolean[].class, new BooleanArrayRenderer());
        metrics.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        metrics.setTableHeader(new JTableHeader(metrics.getColumnModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                return metrics.getModel().getColumnName(index);
            }
        });
        JScrollPane metricsScroller = new JScrollPane(metrics);
        final JTable metricsResults = new JTable();
        metricsResults.setModel(metricsResultsModel);
        metricsResults.setSelectionMode(0);
        metricsResults.setAutoCreateRowSorter(true);
        metricsResults.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        metricsResults.setDefaultRenderer(Boolean[].class, new BooleanArrayRenderer());
        metricsResults.setDefaultRenderer(Number.class, new NumberRenderer());
        metricsResults.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        metricsResults.setTableHeader(new JTableHeader(metricsResults.getColumnModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                return metricsResults.getModel().getColumnName(index);
            }
        });
        metricsResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem normalize = new JMenuItem("Toggle normalize");
                    JMenuItem errors = new JMenuItem("Toggle show errors");
                    normalize.addActionListener(__ -> {
                        int c = metricsResults.columnAtPoint(e.getPoint());
                        String title = metricsResults.getColumnName(c);
                        if (metricsResultsModel.getNormalizedColumn() != null && metricsResultsModel.getNormalizedColumn().equals(title)) {
                            metricsResultsModel.normalizeColumn(null);
                        } else {
                            metricsResultsModel.normalizeColumn(title);
                        }
                    });
                    errors.addActionListener(__ -> metricsResultsModel.enableErrors(!metricsResultsModel.getErrorsEnabled()));
                    menu.add(normalize);
                    menu.add(errors);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JScrollPane performanceResultsScroller = new JScrollPane(metricsResults);
        JSplitPane metricsAndBenchmarksPanel = new JSplitPane(1, metricsScroller, performanceResultsScroller);
        JButton exportButton = new JButton("Export metrics");
        JComboBox<String> parameterComboBox = new JComboBox<String>();
        parameterComboBox.setModel(parameterComboBoxModel);
        parameterComboBox.setPreferredSize(new Dimension(300, 20));
        JButton exportParameterButton = new JButton("Export metrics for parameter");
        exportParameterButton.setEnabled(false);
        JTabbedPane details = new JTabbedPane();
        details.addTab("Log", logScroller);
        details.addTab("Results", testResultsScroller);
        details.addTab("Metrics", metricsAndBenchmarksPanel);
        JButton saveLogButton = new JButton("Save log");
        JButton saveDataButton = new JButton("Save data");
        JButton saveMetricsButton = new JButton("Save metric");
        JButton saveTestResultOverview = new JButton("Save test result overview");
        saveMetricsButton.setEnabled(false);
        JPanel control = new JPanel(new BorderLayout());
        JPanel west = new JPanel();
        west.setLayout(new FlowLayout(0));
        west.add(exportButton);
        west.add(parameterComboBox);
        west.add(exportParameterButton);
        JPanel east = new JPanel();
        east.setLayout(new FlowLayout(2));
        east.add(saveLogButton);
        east.add(saveDataButton);
        east.add(saveMetricsButton);
        east.add(saveTestResultOverview);
        control.add((Component)west, "West");
        control.add((Component)east, "East");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)status, "North");
        panel.add((Component)details, "Center");
        panel.add((Component)control, "South");
        this.LOGGER.finest("creating UI - Details for " + id + " - " + this.predicate + " (Controller)");
        exportButton.addActionListener(e -> this.save(null, id, actionNamesTableModel.get((int)this.actionNameTable.getSelectedRow()).name));
        exportParameterButton.addActionListener(e -> this.saveParameter(null, id, actionNamesTableModel.get((int)this.actionNameTable.getSelectedRow()).name, (String)parameterComboBox.getSelectedItem(), metricsNameModel));
        saveLogButton.addActionListener(e -> this.saveLog(null, id, actionNamesTableModel.get((int)this.actionNameTable.getSelectedRow()).name));
        saveDataButton.addActionListener(e -> this.saveData(null, id, actionNamesTableModel.get((int)this.actionNameTable.getSelectedRow()).name));
        saveMetricsButton.addActionListener(e -> this.saveMetrics(null, id, actionNamesTableModel.get((int)this.actionNameTable.getSelectedRow()).name, metrics.getValueAt(metrics.getSelectedRow(), 0).toString(), metricsResultsModel));
        saveTestResultOverview.addActionListener(e -> this.saveTestResultOverview(null, actionNamesTableModel, id));
        parameterComboBox.addActionListener(e -> exportParameterButton.setEnabled(parameterComboBox.getSelectedItem() != null));
        blame.addActionListener(e -> {
            blame.setEnabled(false);
            this.capabilityAccess.startBlame(id, actionNamesTableModel.get((int)this.actionNameTable.getSelectedRow()).name, report -> SwingUtilities.invokeLater(() -> {
                blame.setEnabled(true);
                BlamingHelper.openBlameReport(tabs, this.projectAccess, id, report);
            }));
        });
        class ThreadMaybe {
            Thread thread;

            ThreadMaybe() {
            }
        }
        ThreadMaybe worker = new ThreadMaybe();
        final Runnable resetAfterTestChange = () -> {
            TestResult selectedTest = this.actionNameTable.getSelectionModel().isSelectionEmpty() ? null : actionNamesTableModel.get(this.actionNameTable.getSelectedRow());
            saveLogButton.setEnabled(selectedTest != null && selectedTest.result != null);
            saveDataButton.setEnabled(selectedTest != null && selectedTest.result != null);
            exportParameterButton.setEnabled(selectedTest != null && parameterComboBox.getSelectedItem() != null);
            blame.setEnabled(selectedTest != null && selectedTest.result != null && selectedTest.result == false);
            description.setText(this.getDescriptionText(selectedTest));
            status.setBorder(new MatteBorder(10, 10, 10, 10, this.getBorderColor(selectedTest)));
            if (worker.thread != null && worker.thread.isAlive()) {
                try {
                    worker.thread.interrupt();
                    worker.thread.join();
                    worker.thread = null;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            log.setText("");
            if (selectedTest != null) {
                RemoteProjectAccess.LogListener listener = line -> SwingUtilities.invokeLater(() -> log.append(line + "\n"));
                Runnable runnable = () -> this.capabilityAccess.getLog(id, selectedTest.name, listener, false, true);
                worker.thread = new Thread(runnable, "PerformanceTestDetails Log Worker");
                worker.thread.setDaemon(true);
                worker.thread.start();
            }
            try {
                String selectedTestName = selectedTest != null ? selectedTest.name : null;
                actionResultsModel.reset(selectedTestName);
                metricsNameModel.reset(selectedTestName);
                metricsResultsModel.reset(selectedTestName, null, true);
                parameterComboBoxModel.reset();
            }
            catch (IOException | InterruptedException e) {
                Errors.showInternal(null, e);
            }
        };
        Runnable resetAfterMetricsChange = () -> {
            TestResult selectedTest = this.actionNameTable.getSelectionModel().isSelectionEmpty() ? null : actionNamesTableModel.get(this.actionNameTable.getSelectedRow());
            String selectedMetric = metrics.getSelectionModel().isSelectionEmpty() ? null : metrics.getValueAt(metrics.getSelectedRow(), 0).toString();
            try {
                metricsResultsModel.reset(selectedTest != null ? selectedTest.name : null, selectedMetric, false);
                if (selectedTest != null && selectedMetric != null) {
                    saveMetricsButton.setEnabled(true);
                    saveMetricsButton.setText("Save metric (" + selectedMetric + ")");
                    exportParameterButton.setEnabled(parameterComboBox.getSelectedItem() != null);
                } else {
                    saveMetricsButton.setEnabled(false);
                    saveMetricsButton.setText("Save metric");
                    exportParameterButton.setEnabled(false);
                }
            }
            catch (InterruptedException e) {
                this.LOGGER.fine("Thread interruption while resetting performance result model");
            }
        };
        this.actionNameTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                resetAfterTestChange.run();
            }
        });
        metrics.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                resetAfterMetricsChange.run();
            }
        });
        SafeRemoteMap.Listener<BuildID> listener = new SafeRemoteMap.Listener<BuildID>(){

            @Override
            public void added(BuildID __) {
            }

            @Override
            public void removed(BuildID __) {
            }

            @Override
            public void changed(BuildID key) {
                if (id.equals(key)) {
                    resetAfterTestChange.run();
                }
            }

            @Override
            public void closed() {
            }
        };
        this.projectAccess.addListener(listener);
        closeables.add(() -> this.projectAccess.removeListener(listener));
        closeables.add(actionNamesTableModel);
        closeables.add(metricsResultsModel);
        closeables.add(metricsNameModel);
        closeables.add(() -> {
            if (worker.thread != null) {
                worker.thread.interrupt();
            }
        });
        this.LOGGER.finest("creating UI - Details for " + id + " - Performance Tests (Controller initializing)");
        resetAfterTestChange.run();
        if (test != null) {
            for (int index = 0; index < actionNamesTableModel.getRowCount(); ++index) {
                TestResult result = actionNamesTableModel.get(index);
                if (!result.name.equals(test)) continue;
                this.actionNameTable.getSelectionModel().setSelectionInterval(index, index);
                break;
            }
        }
        this.setOrientation(1);
        this.setLeftComponent(testsScroller);
        this.setRightComponent(panel);
    }

    private Color getBorderColor(TestResult selectedTest) {
        Color borderColor = selectedTest != null ? BooleanRenderer.getColor(selectedTest.result) : Color.WHITE;
        return borderColor;
    }

    private String getDescriptionText(TestResult selectedTest) {
        String descriptionText = "";
        descriptionText = selectedTest != null ? (selectedTest.result != null ? (selectedTest.result.booleanValue() ? this.predicate + " successful" : this.predicate + " failed") : this.predicate + " result unavailable (yet?)") : "Please select a " + this.predicate;
        return descriptionText;
    }

    private void save(Component parent, BuildID id, String action) {
        JFileChooserUtil.chooseFileAndSave(parent, false, JFileChooserUtil.generatePath(this.projectAccess.getName(), id.toIdSortedString(), this.actionType, action + "_metric", ".csv"), file -> {
            MetricsNameTableModel names = new MetricsNameTableModel(this.capabilityAccess, id);
            names.reset(action);
            MetricResults results = new MetricResults(this.capabilityAccess, id);
            results.setTest(action);
            results.fillMetaData();
            results.downloadFolder();
            results.parseDownloadFolder();
            String[] benchmarks = results.getBenchmarks().toArray(new String[0]);
            String[] parameters = results.getParameters().toArray(new String[0]);
            String[] metrics = (String[])IntStream.range(0, names.getRowCount()).mapToObj(row -> names.get(row)).toArray(String[]::new);
            names.close();
            results.clear(true);
            HashMap performances = new HashMap();
            for (String metric : metrics) {
                results.setMetric(metric);
                results.parseDownloadFolder();
                HashMap performancesForMetric = (HashMap)performances.get(metric);
                if (performancesForMetric == null) {
                    performancesForMetric = new HashMap();
                    performances.put(metric, performancesForMetric);
                }
                for (String benchmark : benchmarks) {
                    HashMap<String, Average<Double>> performancesForBenchmark = (HashMap<String, Average<Double>>)performancesForMetric.get(benchmark);
                    if (performancesForBenchmark == null) {
                        performancesForBenchmark = new HashMap<String, Average<Double>>();
                        performancesForMetric.put(benchmark, performancesForBenchmark);
                    }
                    for (String parameter : parameters) {
                        performancesForBenchmark.put(parameter, results.getValue(benchmark, parameter));
                    }
                }
                results.clear(true);
            }
            try (FileWriter writer = new FileWriter(file);){
                writer.write("Suite,Benchmark,");
                for (String parameter : parameters) {
                    for (String metric : metrics) {
                        writer.write(parameter.replace("=", " ") + " " + metric + ",");
                        writer.write(parameter.replace("=", " ") + " " + metric + "_error_down,");
                        writer.write(parameter.replace("=", " ") + " " + metric + "_error_up,");
                    }
                }
                writer.append('\n');
                for (String benchmark : benchmarks) {
                    writer.write(benchmark.substring(0, benchmark.indexOf(32)).replace('_', ' ') + ",");
                    writer.write(benchmark.substring(benchmark.indexOf(32) + 1, benchmark.length()).replace('_', ' ') + ",");
                    for (String parameter : parameters) {
                        for (String metric : metrics) {
                            Map performancesForMetric = (Map)performances.get(metric);
                            if (performancesForMetric == null) {
                                writer.write(",,,");
                                continue;
                            }
                            Map performancesForBenchmark = (Map)performancesForMetric.get(benchmark);
                            if (performancesForBenchmark == null) {
                                writer.write(",,,");
                                continue;
                            }
                            Average value = (Average)performancesForBenchmark.get(parameter);
                            if (value == null || Double.isNaN((Double)value.value)) {
                                writer.write(",,,");
                                continue;
                            }
                            writer.write(String.format("%.8f,%.8f,%.8f,", value.value, value.errorDown, value.errorUp));
                        }
                    }
                    writer.append('\n');
                }
            }
        });
    }

    private void saveMetrics(Component parent, BuildID id, String actionName, String metric, MetricsResultsTableModel performanceModel) {
        StringBuilder metricsCsv = new StringBuilder();
        for (int col = 0; col < performanceModel.getColumnCount(); ++col) {
            metricsCsv.append(performanceModel.getColumnName(col));
            metricsCsv.append(",");
        }
        metricsCsv.append("\n");
        for (int row = 0; row < performanceModel.getRowCount(); ++row) {
            for (int col = 0; col < performanceModel.getColumnCount(); ++col) {
                Object valueAtObj = performanceModel.getValueAt(row, col);
                if (valueAtObj == null) {
                    valueAtObj = "";
                }
                if (valueAtObj instanceof Number) {
                    Number number = (Number)valueAtObj;
                    valueAtObj = valueAtObj == null || Double.isNaN(number.doubleValue()) ? "" : (number.doubleValue() == (double)number.longValue() ? String.valueOf(number.longValue()) : String.format("%.8f", number.doubleValue()));
                }
                metricsCsv.append(valueAtObj.toString().replace("_", " "));
                metricsCsv.append(",");
            }
            metricsCsv.append("\n");
        }
        JFileChooserUtil.chooseFileAndSave(parent, false, JFileChooserUtil.generatePath(this.projectAccess.getName(), id.toIdSortedString(), this.actionType, actionName + "_metric_" + metric, ".csv"), metricsFile -> {
            try (FileWriter fw = new FileWriter(metricsFile);){
                fw.write(metricsCsv.toString());
            }
        });
    }

    private void saveTestResultOverview(Component parent, ActionNamesTableModel actionNamesTableModel, BuildID id) {
        StringBuilder all = new StringBuilder();
        StringBuilder negatives = new StringBuilder();
        StringBuilder fails = new StringBuilder();
        for (int testId = 0; testId < actionNamesTableModel.getRowCount(); ++testId) {
            this.LOGGER.fine(String.format("Generate test %d/%d", testId + 1, actionNamesTableModel.getRowCount()));
            TestResult testResult = actionNamesTableModel.get(testId);
            ActionResults actionResults = new ActionResults(this.capabilityAccess, id);
            actionResults.reset(testResult.name, true);
            all.append(testResult.name + "\n");
            all.append("Suite");
            all.append(",");
            all.append("Benchmark");
            for (String parameter : actionResults.getParameters()) {
                all.append(",");
                all.append(parameter);
            }
            all.append("\n");
            negatives.append(testResult.name + "\n");
            negatives.append("Suite");
            negatives.append(",");
            negatives.append("Benchmark");
            negatives.append(",");
            negatives.append("Parameter");
            negatives.append(",");
            negatives.append("Failed project");
            negatives.append(",");
            negatives.append("Fail type");
            negatives.append("\n");
            fails.append(testResult.name + "\n");
            fails.append("Suite");
            fails.append(",");
            fails.append("Benchmark");
            fails.append(",");
            fails.append("Parameter");
            fails.append(",");
            fails.append("Failed project");
            fails.append("\n");
            for (String benchmark : actionResults.getBenchmarks()) {
                String suiteName = benchmark.split(" ")[0];
                String benchmarkName = benchmark.split(" ")[1];
                all.append(suiteName);
                all.append(",");
                all.append(benchmarkName);
                for (String parameter : actionResults.getParameters()) {
                    ExecutionResult[] results = actionResults.getResultsFor(benchmark).get(parameter);
                    int nResults = results != null ? results.length : 0;
                    all.append(",");
                    for (int resIdx = 0; resIdx < nResults; ++resIdx) {
                        boolean vm;
                        boolean bl = vm = resIdx % 2 == 0;
                        if (vm) {
                            all.append(" VM=");
                        } else {
                            all.append(" Test=");
                        }
                        if (results[resIdx].asBoolean() == null) {
                            all.append("unable");
                            negatives.append(suiteName);
                            negatives.append(",");
                            negatives.append(benchmarkName);
                            negatives.append(",");
                            negatives.append(parameter);
                            negatives.append(",");
                            negatives.append(vm ? "VM" : "Test");
                            negatives.append(",");
                            negatives.append("unable");
                            negatives.append("\n");
                            continue;
                        }
                        if (results[resIdx].asBoolean().booleanValue()) {
                            all.append("run");
                            continue;
                        }
                        all.append("fail");
                        negatives.append(suiteName);
                        negatives.append(",");
                        negatives.append(benchmarkName);
                        negatives.append(",");
                        negatives.append(parameter);
                        negatives.append(",");
                        negatives.append(vm ? "VM" : "Test");
                        negatives.append(",");
                        negatives.append("fail");
                        negatives.append("\n");
                        fails.append(suiteName);
                        fails.append(",");
                        fails.append(benchmarkName);
                        fails.append(",");
                        fails.append(parameter);
                        fails.append(",");
                        fails.append(vm ? "VM" : "Test");
                        fails.append("\n");
                    }
                }
                all.append("\n");
            }
            all.append("\n");
            negatives.append("\n");
            fails.append("\n");
        }
        JFileChooserUtil.chooseFileAndSave(parent, true, JFileChooserUtil.generatePath(this.projectAccess.getName(), id.toIdSortedString(), this.actionType, "overview", null), dir -> {
            dir.mkdir();
            try (FileWriter fw = new FileWriter(dir + File.separator + "results.csv", false);){
                fw.write(all.toString());
            }
            fw = new FileWriter(dir + File.separator + "negatives.csv");
            var8_9 = null;
            try {
                fw.write(negatives.toString());
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (fw != null) {
                    if (var8_9 != null) {
                        try {
                            fw.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        fw.close();
                    }
                }
            }
            fw = new FileWriter(dir + File.separator + "fails.csv");
            var8_9 = null;
            try {
                fw.write(fails.toString());
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (fw != null) {
                    if (var8_9 != null) {
                        try {
                            fw.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        fw.close();
                    }
                }
            }
            for (int testId = 0; testId < actionNamesTableModel.getRowCount(); ++testId) {
                this.LOGGER.fine(String.format("Generate test %d/%d", testId + 1, actionNamesTableModel.getRowCount()));
                TestResult testResult = actionNamesTableModel.get(testId);
                File testDir = new File(dir + File.separator + testResult.name);
                testDir.mkdir();
                this.capabilityAccess.getDirectory(id, testResult.name, testDir, ".test", ".out");
                if (Stream.of(testDir.getAbsoluteFile().listFiles()).filter(f -> !f.isHidden()).filter(f -> !f.getName().startsWith(".")).count() == 0L) {
                    FileUtil.deleteTree(testDir);
                    continue;
                }
                try (LogWriter out = new LogWriter(new FileWriter(dir + File.separator + testResult.name + ".data"));){
                    this.capabilityAccess.getData(id, testResult.name, out, true, false);
                    continue;
                }
            }
        });
    }

    private void saveParameter(Component parent, BuildID id, String testName, String parameter, MetricsNameTableModel metricsNameModel) {
        StringBuilder csv = new StringBuilder();
        MetricResults result = new MetricResults(this.capabilityAccess, id);
        result.setTest(testName);
        result.fillMetaData();
        result.downloadFolder();
        csv.append("Suite");
        csv.append(",");
        csv.append("Benchmark");
        csv.append(",");
        for (int metricNameIdx = 0; metricNameIdx < metricsNameModel.getRowCount(); ++metricNameIdx) {
            String metric = (String)metricsNameModel.getValueAt(metricNameIdx, 0);
            csv.append(metric);
            csv.append(",");
            csv.append(metric + "_error_down");
            csv.append(",");
            csv.append(metric + "_error_up");
            csv.append(",");
        }
        csv.append("\n");
        List<String> benchmarks = result.getBenchmarks();
        for (int benchmarkNameIdx = 0; benchmarkNameIdx < benchmarks.size(); ++benchmarkNameIdx) {
            String benchmark = benchmarks.get(benchmarkNameIdx);
            csv.append(benchmark.substring(0, benchmark.indexOf(32)).replace("_", " "));
            csv.append(",");
            csv.append(benchmark.substring(benchmark.indexOf(32) + 1).replace("_", " "));
            csv.append(",");
            for (int metricNameIdx = 0; metricNameIdx < metricsNameModel.getRowCount(); ++metricNameIdx) {
                String metric = (String)metricsNameModel.getValueAt(metricNameIdx, 0);
                result.clear(true);
                result.setMetric(metric);
                try {
                    result.parseDownloadFolder();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Average<Double> valueAtObj = result.getValue(benchmark, parameter);
                String valueAt = valueAtObj == null || Double.isNaN(valueAtObj.doubleValue()) ? ",," : String.format("%.8f,%.8f,%.8f", valueAtObj.doubleValue(), valueAtObj.errorDown, valueAtObj.errorUp);
                csv.append(valueAt);
                csv.append(",");
            }
            csv.append("\n");
        }
        JFileChooserUtil.chooseFileAndSave(parent, false, JFileChooserUtil.generatePath(this.projectAccess.getName(), id.toIdSortedString(), this.actionType, testName + "_parameter_" + parameter, ".csv"), metricsFile -> {
            try (FileWriter fw = new FileWriter(metricsFile);){
                fw.write(csv.toString());
            }
        });
    }

    private void saveLog(Component parent, BuildID id, String testName) {
        if (this.capabilityAccess != null) {
            JFileChooserUtil.chooseFileAndSave(parent, false, JFileChooserUtil.generatePath(this.projectAccess.getName(), id.toIdSortedString(), this.actionType, testName, ".log"), log -> {
                try (LogWriter out = new LogWriter(new FileWriter(log));){
                    this.capabilityAccess.getLog(id, testName, out, true, false);
                }
            });
        }
    }

    private void saveData(Component parent, BuildID id, String testName) {
        if (this.capabilityAccess != null) {
            JFileChooserUtil.chooseFileAndSave(parent, true, JFileChooserUtil.generatePath(this.projectAccess.getName(), id.toIdSortedString(), this.actionType, testName, null), dir -> {
                this.capabilityAccess.getDirectory(id, testName, dir, new String[0]);
                try (LogWriter out = new LogWriter(new FileWriter(dir + File.separator + testName + ".data"));){
                    this.capabilityAccess.getData(id, testName, out, true, false);
                }
            });
        }
    }
}

