/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.util;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public abstract class LazyKeyValueTableModel<Key extends Comparable<Key>, Value>
extends AbstractTableModel
implements TableModel,
Closeable {
    private static final long serialVersionUID = 1L;
    private final List<Key> list = Collections.synchronizedList(new ArrayList());
    private final Map<Key, Value> map = Collections.synchronizedMap(new HashMap());
    private final BlockingQueue<Runnable> actions = new LinkedBlockingQueue<Runnable>();
    private final Thread worker = new Thread(this::run, LazyKeyValueTableModel.class.getSimpleName() + " Worker");

    protected LazyKeyValueTableModel() {
        this.worker.setDaemon(true);
        this.worker.start();
    }

    @Override
    public void close() {
        this.worker.interrupt();
    }

    private void run() {
        assert (this.worker == Thread.currentThread());
        while (!this.worker.isInterrupted()) {
            try {
                this.actions.take().run();
            }
            catch (InterruptedException e) {
                this.worker.interrupt();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                assert (false);
                try {
                    SwingUtilities.invokeAndWait(this::fireTableDataChanged);
                    SwingUtilities.invokeAndWait(this::fireTableDataChanged);
                }
                catch (InterruptedException | InvocationTargetException exception) {}
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addKey(Key key) {
        if (this.worker == Thread.currentThread()) {
            try {
                if (this.map.containsKey(key)) return;
                this.list.add(key);
                this.map.put(key, null);
                int index = this.list.indexOf(key);
                SwingUtilities.invokeAndWait(() -> this.fireTableRowsInserted(index, index));
                return;
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.actions.add(() -> this.addKey(key));
        }
    }

    protected void clearValue(Key key) {
        if (this.worker == Thread.currentThread()) {
            try {
                if (!this.map.containsKey(key)) {
                    this.addKey(key);
                }
                this.map.remove(key);
                int index = this.list.indexOf(key);
                SwingUtilities.invokeAndWait(() -> this.fireTableRowsUpdated(index, index));
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.actions.add(() -> this.clearValue(key));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void removeKey(Key key) {
        if (this.worker == Thread.currentThread()) {
            try {
                if (!this.map.containsKey(key)) return;
                int index = this.list.indexOf(key);
                this.list.remove(index);
                this.map.remove(key);
                SwingUtilities.invokeAndWait(() -> this.fireTableRowsDeleted(index, index));
                return;
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.actions.add(() -> this.removeKey(key));
        }
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public final Object getValueAt(int row, int column) {
        Comparable key = (Comparable)this.list.get(row);
        Value value = this.map.get(key);
        if (value == null) {
            this.actions.add(() -> {
                assert (this.worker == Thread.currentThread());
                try {
                    if (this.map.get(key) != null) {
                        return;
                    }
                    Value newValue = this.getValueOfKey(key);
                    this.map.put(key, newValue);
                    int index = this.list.indexOf(key);
                    SwingUtilities.invokeAndWait(() -> {
                        this.fireTableRowsUpdated(index, index);
                        this.fireTableRowsUpdated(index, index);
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return this.getValueAt(key, value, column);
    }

    protected abstract Value getValueOfKey(Key var1);

    protected abstract Object getValueAt(Key var1, Value var2, int var3);
}

