/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class JCloseableTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1342123737514379547L;

    @Override
    public void addTab(String title, Icon icon, Component component) {
        this.addTab(title, icon, component, false, null);
    }

    public void addTab(String title, Icon icon, Component content, boolean closeable, Runnable onClose) {
        if (!closeable && onClose != null) {
            throw new IllegalArgumentException();
        }
        int index = this.getTabCount();
        super.addTab(title, icon, content);
        if (closeable) {
            Component header = this.createHeader(title, icon, this.getTabComponentAt(index), onClose);
            this.setTabComponentAt(index, header);
            this.setSelectedIndex(index);
        }
    }

    private Component createHeader(String title, Icon icon, Component header, Runnable onClose) {
        if (header == null) {
            header = new JLabel(title, icon, 2);
        }
        JButton button = new JButton("x");
        button.setPreferredSize(new Dimension(20, 20));
        button.addActionListener(e -> this.close(title, onClose));
        JPanel panel = new JPanel(new FlowLayout(2, 5, 0));
        panel.add(header);
        panel.add(button);
        return panel;
    }

    private void close(String title, Runnable onClose) {
        this.removeTabAt(this.getIndexOfTab(title));
        if (onClose != null) {
            onClose.run();
        }
    }

    private int getIndexOfTab(String title) {
        for (int index = 0; index < this.getTabCount(); ++index) {
            if (!this.getTitleAt(index).equals(title)) continue;
            return index;
        }
        return -1;
    }

    public boolean selectTab(String header) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            String name = this.getTitleAt(i);
            if (!header.equals(name)) continue;
            this.setSelectedIndex(i);
            return true;
        }
        return false;
    }
}

