/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.renderer;

import at.jku.ssw.mevss.cerberus.ci.client.renderer.Average;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.Percentage;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;

public class NumberRenderer
implements TableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = new JLabel();
        label.setHorizontalAlignment(4);
        if (isSelected) {
            label.setOpaque(true);
            label.setBackground(UIManager.getDefaults().getColor("List.selectionBackground"));
        }
        if (hasFocus) {
            label.setBorder(LineBorder.createBlackLineBorder());
        }
        DecimalFormat format = new DecimalFormat("#,##0.000");
        if (value != null) {
            if (((Number)value).doubleValue() == 0.0) {
                label.setForeground(Color.LIGHT_GRAY);
            }
            if (value instanceof Double) {
                label.setText(format.format(value));
            } else if (value instanceof Long) {
                label.setText(value.toString());
            } else if (value instanceof Percentage) {
                label.setText(format.format(value) + "%");
            } else if (value instanceof Average) {
                Average avg = (Average)value;
                if (avg.value instanceof Double) {
                    label.setText(format.format(((Number)avg.value).doubleValue()) + " (-" + format.format(((Number)avg.errorDown).doubleValue()) + ",+" + format.format(((Number)avg.errorUp).doubleValue()) + ")");
                } else if (avg.value instanceof Percentage) {
                    label.setText(format.format(((Number)avg.value).doubleValue()) + "% (-" + format.format(((Number)avg.errorDown).doubleValue()) + "%,+" + format.format(((Number)avg.errorUp).doubleValue()) + "%)");
                } else {
                    label.setText(avg.value + " (-" + avg.errorDown + ",+" + avg.errorUp + ")");
                }
            } else {
                label.setText(value.toString());
            }
        }
        return label;
    }
}

