/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.renderer;

import at.jku.ssw.mevss.cerberus.ci.client.model.details.ExecutionResult;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.BooleanArrayRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.stream.Stream;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ExecutionResultArrayRenderer
extends DefaultTableCellRenderer {
    private final BooleanArrayRenderer booleanArrayRenderer = new BooleanArrayRenderer();
    private boolean reduceToBoolean = true;
    private ExecutionResult[] currentValues;
    private boolean darken;
    private JTable table;
    private int row;
    private int column;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.table = table;
        this.row = row;
        this.column = column;
        return this.getTableCellRendererComponent((ExecutionResult[])value, isSelected);
    }

    public Component getTableCellRendererComponent(ExecutionResult[] values, boolean isSelected) {
        if (this.reduceToBoolean) {
            return this.booleanArrayRenderer.getTableCellRendererComponent((Boolean[])Stream.of(values).map(x -> x.asBoolean()).toArray(Boolean[]::new), isSelected);
        }
        this.currentValues = values;
        this.darken = isSelected;
        return this;
    }

    @Override
    public void paint(Graphics g) {
        if (this.currentValues == null || this.currentValues.length == 0) {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            int width = this.getWidth() / this.currentValues.length;
            int height = this.getHeight();
            for (int i = 0; i < this.currentValues.length; ++i) {
                g.setColor(ExecutionResultArrayRenderer.getColor(this.currentValues[i], this.darken));
                g.fillRect(width * i, 0, width, height);
                g.setColor(Color.BLACK);
                g.drawLine(width * i, 0, width * i, height);
            }
            g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, height);
            g.fillRect(width * this.currentValues.length, 0, this.getWidth(), height);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.currentValues == null || this.currentValues.length == 0) {
            return null;
        }
        Rectangle cell = this.table.getCellRect(this.row, this.column, false);
        int widthPerElement = cell.width / this.currentValues.length;
        if (widthPerElement == 0) {
            return null;
        }
        int element = event.getX() / widthPerElement;
        return this.currentValues[element].toString();
    }

    public static Color getColor(ExecutionResult result, boolean isSelected) {
        Color color;
        switch (result) {
            case RUN_SUCCEEDED: 
            case TEST_SUCCEEDED: {
                color = Color.GREEN;
                break;
            }
            case RUN_CRASHED: 
            case TEST_CRASHED: {
                color = Color.RED;
                break;
            }
            case RUN_FAILED: 
            case TEST_FAILED: {
                color = Color.ORANGE;
                break;
            }
            case RUN_TIMEOUT: 
            case TEST_TIMEOUT: {
                color = Color.MAGENTA;
                break;
            }
            case RUN_CRASHED_WITH_KNOWN_BUG: 
            case TEST_CRASHED_WITH_KNOWN_BUG: {
                color = Color.GREEN.darker();
                break;
            }
            case TEST_UNABLE: {
                color = Color.LIGHT_GRAY;
                break;
            }
            default: {
                color = Color.BLACK;
            }
        }
        if (isSelected) {
            color.darker();
        }
        return color;
    }

    public void switchMode() {
        this.reduceToBoolean = !this.reduceToBoolean;
    }
}

