/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.model.overview;

import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.data.SafeRemoteMap;
import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class OverviewTestsModel
extends AbstractTableModel
implements TableModel {
    private static final long serialVersionUID = -4140743948238155252L;
    private static final String[] COLUMN_NAMES = new String[]{"Test", "OS", "Architecture", "Address Length", "Test State", "Details", "Run"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, Integer.class, Boolean.class, Runnable.class, Runnable.class};
    private static final boolean[] COLUMNS_MUTABILITY = new boolean[]{false, false, false, false, true, true, false};
    private final RemoteProjectAccess data;
    private final RemoteProjectAccess.ActionAccess access;
    private final BiConsumer<BuildID, String> openAction;
    private final BiConsumer<BuildID, String> retestAction;
    private final List<BuildID> envs;
    private final List<String> tests;
    private Map<BuildID, HashMap<String, BuildID>> latestsPerEnv;
    private final BlockingQueue<BuildID> reloading;
    private final Thread worker;

    public OverviewTestsModel(RemoteProjectAccess data, BiConsumer<BuildID, String> openAction, BiConsumer<BuildID, String> retestAction, Capability responsibility) {
        this.data = data;
        switch (responsibility) {
            case FUNCTIONAL_TEST: {
                this.access = data.testAccess;
                break;
            }
            case PERFORMANCE_TEST: {
                this.access = data.performanceAccess;
                break;
            }
            default: {
                assert (false);
                this.access = null;
            }
        }
        this.openAction = openAction;
        this.retestAction = retestAction;
        this.envs = Collections.synchronizedList(new ArrayList());
        this.tests = Collections.synchronizedList(new ArrayList());
        this.latestsPerEnv = Collections.synchronizedMap(new HashMap());
        this.reloading = new LinkedBlockingQueue<BuildID>();
        this.worker = new Thread(this::run, OverviewTestsModel.class.getSimpleName() + " Worker");
        this.worker.setDaemon(true);
        this.worker.start();
    }

    private void run() {
        this.envs.addAll(Arrays.asList(this.data.getEnvironments()));
        SwingUtilities.invokeLater(this::fireTableDataChanged);
        this.tests.addAll(Arrays.asList(this.access.get()));
        SwingUtilities.invokeLater(this::fireTableDataChanged);
        this.latestsPerEnv = this.access.getLatestResults();
        SwingUtilities.invokeLater(() -> this.fireTableDataChanged());
        this.data.addListener(new SafeRemoteMap.Listener<BuildID>(){

            @Override
            public void added(BuildID key) {
                OverviewTestsModel.this.reloading.add(key);
            }

            @Override
            public void removed(BuildID key) {
                OverviewTestsModel.this.reloading.add(key);
            }

            @Override
            public void changed(BuildID key) {
                OverviewTestsModel.this.reloading.add(key);
            }

            @Override
            public void closed() {
                OverviewTestsModel.this.worker.interrupt();
            }
        });
        assert (this.worker == Thread.currentThread());
        while (!this.worker.isInterrupted()) {
            try {
                BuildID id = this.reloading.take();
                BuildID env = id.toEnv();
                HashMap<String, BuildID> latestTestsInEnv = this.latestsPerEnv.get(env);
                if (latestTestsInEnv == null) {
                    latestTestsInEnv = new HashMap();
                    this.latestsPerEnv.put(env, latestTestsInEnv);
                }
                for (String test : this.tests) {
                    BuildID latestBuildForTest = latestTestsInEnv.get(test);
                    if (latestBuildForTest == null) {
                        BuildID latest = this.access.getLatestBuild(env, test);
                        if (latest == null) continue;
                        latestTestsInEnv.put(test, latest);
                        this.data.getValue(latest);
                    } else if (!id.equals(latestBuildForTest) && latestBuildForTest != null && id.getID() < latestBuildForTest.getID()) continue;
                    int row = this.getRow(env, test);
                    for (int column = 0; column < COLUMNS_MUTABILITY.length; ++column) {
                        if (!COLUMNS_MUTABILITY[column]) continue;
                        int col = column;
                        SwingUtilities.invokeLater(() -> this.fireTableCellUpdated(row, col));
                    }
                }
            }
            catch (InterruptedException e) {
                this.worker.interrupt();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                assert (false);
                System.exit(1);
            }
        }
    }

    private int findIndex(BuildID env) {
        for (int index = 0; index < this.envs.size(); ++index) {
            if (!this.envs.get(index).equals(env)) continue;
            return index;
        }
        this.envs.add(env);
        SwingUtilities.invokeLater(this::fireTableDataChanged);
        return this.findIndex(env);
    }

    private int findIndex(String test) {
        for (int index = 0; index < this.tests.size(); ++index) {
            if (!this.tests.get(index).equals(test)) continue;
            return index;
        }
        this.tests.add(test);
        SwingUtilities.invokeLater(this::fireTableDataChanged);
        return this.findIndex(test);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return COLUMN_CLASSES[column];
    }

    @Override
    public int getRowCount() {
        return this.tests.size() * this.envs.size();
    }

    private int getRow(BuildID env, String test) {
        return this.findIndex(env) + this.findIndex(test) * this.envs.size();
    }

    private String getTestFromRow(int row) {
        return this.tests.get(row / this.envs.size());
    }

    private BuildID getEnvFromRow(int row) {
        return this.envs.get(row % this.envs.size());
    }

    @Override
    public Object getValueAt(int row, int column) {
        String test = this.getTestFromRow(row);
        BuildID env = this.getEnvFromRow(row);
        BuildID id = this.get(env, test);
        switch (column) {
            case 0: {
                return test;
            }
            case 1: {
                return (id != null ? id : env).getOS();
            }
            case 2: {
                return (id != null ? id : env).getArchitecture();
            }
            case 3: {
                return (id != null ? id : env).getAddressLength();
            }
            case 4: {
                return id != null ? this.access.getResults(id).get(test) : null;
            }
            case 5: {
                return id != null ? () -> this.openAction.accept(id, test) : null;
            }
            case 6: {
                return () -> this.retestAction.accept(env, test);
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return COLUMN_CLASSES[column] == Runnable.class;
    }

    private BuildID get(BuildID env, String test) {
        Map latests = this.latestsPerEnv.get(env);
        if (latests == null) {
            return null;
        }
        return (BuildID)latests.get(test);
    }
}

