/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.model.overview;

import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.data.SafeRemoteMap;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildInfo;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class OverviewBuildsModel
extends AbstractTableModel
implements TableModel,
Closeable {
    private static final long serialVersionUID = -5829492655399246872L;
    private static final String[] COLUMN_NAMES = new String[]{"OS", "Architecture", "Address Length", "Build State", "Details", "Run"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, Integer.class, Boolean.class, Runnable.class, Runnable.class};
    private static final boolean[] COLUMNS_MUTABILITY = new boolean[]{false, false, false, true, true, false};
    private final RemoteProjectAccess data;
    private final Consumer<BuildID> openAction;
    private final Consumer<BuildID> rebuildAction;
    private final List<BuildID> envs;
    private final Map<BuildID, BuildID> latests;
    private final BlockingQueue<BuildID> reloading;
    private final Thread worker;

    public OverviewBuildsModel(RemoteProjectAccess data, Consumer<BuildID> openAction, Consumer<BuildID> rebuildAction) {
        this.data = data;
        this.openAction = openAction;
        this.rebuildAction = rebuildAction;
        this.envs = Collections.synchronizedList(new ArrayList());
        this.latests = Collections.synchronizedMap(new HashMap());
        this.reloading = new LinkedBlockingQueue<BuildID>();
        this.worker = new Thread(this::run, OverviewBuildsModel.class.getSimpleName() + " Worker");
        this.worker.setDaemon(true);
        this.worker.start();
        data.addListener(new SafeRemoteMap.Listener<BuildID>(){

            @Override
            public void added(BuildID key) {
                OverviewBuildsModel.this.reloading.add(key);
            }

            @Override
            public void removed(BuildID key) {
                OverviewBuildsModel.this.reloading.add(key);
            }

            @Override
            public void changed(BuildID key) {
                OverviewBuildsModel.this.reloading.add(key);
            }

            @Override
            public void closed() {
                OverviewBuildsModel.this.worker.interrupt();
            }
        });
    }

    @Override
    public void close() {
        this.worker.interrupt();
    }

    private void run() {
        this.envs.addAll(Arrays.asList(this.data.getEnvironments()));
        SwingUtilities.invokeLater(this::fireTableDataChanged);
        this.reloading.addAll(this.envs);
        assert (this.worker == Thread.currentThread());
        while (!this.worker.isInterrupted()) {
            try {
                BuildID id = this.reloading.take();
                BuildID env = id.toEnv();
                BuildID latest = this.latests.get(env);
                if (!id.equals(latest)) {
                    BuildID newLatest;
                    if (latest != null && id.getID() < latest.getID() || (newLatest = this.data.buildAccess.getLatestBuild(env, "build")) == null || newLatest.equals(latest)) continue;
                    this.latests.put(env, newLatest);
                    this.data.getValue(newLatest);
                }
                int row = this.findRow(env);
                for (int column = 0; column < COLUMNS_MUTABILITY.length; ++column) {
                    if (!COLUMNS_MUTABILITY[column]) continue;
                    int col = column;
                    SwingUtilities.invokeLater(() -> this.fireTableCellUpdated(row, col));
                }
            }
            catch (InterruptedException e) {
                this.worker.interrupt();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                assert (false);
                System.exit(1);
            }
        }
    }

    private int findRow(BuildID env) {
        int index;
        for (index = 0; index < this.envs.size(); ++index) {
            if (!this.envs.get(index).equals(env)) continue;
            return index;
        }
        this.envs.add(env);
        int newIndex = this.findRow(env);
        SwingUtilities.invokeLater(() -> this.fireTableRowsInserted(newIndex, newIndex));
        return index;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return COLUMN_CLASSES[column];
    }

    @Override
    public int getRowCount() {
        return this.envs.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        BuildID env = this.envs.get(row);
        BuildID latest = this.latests.get(env);
        switch (column) {
            case 0: {
                return env.getOS();
            }
            case 1: {
                return env.getArchitecture();
            }
            case 2: {
                return env.getAddressLength();
            }
            case 3: {
                return latest != null && latest.getID() != 0L ? ((BuildInfo)this.data.getValue(latest)).getBuildResult() : null;
            }
            case 4: {
                return latest != null && latest.getID() != 0L ? () -> this.openAction.accept(latest) : null;
            }
            case 5: {
                return () -> this.rebuildAction.accept(env);
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return COLUMN_CLASSES[column] == Runnable.class;
    }
}

