/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.model.history;

import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.data.SafeRemoteMap;
import at.jku.ssw.mevss.cerberus.ci.client.util.LazyKeyValueTableModel;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildInfo;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.function.Consumer;

public class HistoryTableModel
extends LazyKeyValueTableModel<BuildID, BuildInfo> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"Date", "Name", "OS", "Architecture", "Address length", "Build", "Functional Tests", "Performance Tests", "Details", "Redo"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{Date.class, String.class, String.class, String.class, Integer.class, Boolean.class, Boolean[].class, Integer.class, Runnable.class, Runnable.class};
    private final RemoteProjectAccess data;
    private final Consumer<BuildID> openAction;
    private final Consumer<BuildID> redoAction;

    public HistoryTableModel(RemoteProjectAccess data, Consumer<BuildID> openAction, Consumer<BuildID> redoAction) throws RemoteException {
        this.data = data;
        this.openAction = openAction;
        this.redoAction = redoAction;
        this.data.addListener(new SafeRemoteMap.Listener<BuildID>(){

            @Override
            public void added(BuildID key) {
                HistoryTableModel.this.addKey(key);
            }

            @Override
            public void removed(BuildID key) {
                HistoryTableModel.this.removeKey(key);
            }

            @Override
            public void changed(BuildID key) {
                HistoryTableModel.this.clearValue(key);
            }

            @Override
            public void closed() {
                HistoryTableModel.this.close();
            }
        });
        for (BuildID id : (BuildID[])this.data.getKeys()) {
            this.addKey(id);
        }
    }

    @Override
    protected BuildInfo getValueOfKey(BuildID id) {
        return (BuildInfo)this.data.getValue(id);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return COLUMN_CLASSES[column];
    }

    @Override
    protected Object getValueAt(BuildID id, BuildInfo info, int column) {
        switch (column) {
            case 0: {
                return info != null ? info.getTime() : null;
            }
            case 1: {
                return info != null ? info.getName() : null;
            }
            case 2: {
                return id.getOS();
            }
            case 3: {
                return id.getArchitecture();
            }
            case 4: {
                return id.getAddressLength();
            }
            case 5: {
                return info != null ? info.getBuildResult() : null;
            }
            case 6: {
                return info != null ? info.getTestResults().values().stream().toArray(Boolean[]::new) : null;
            }
            case 7: {
                return info != null ? Integer.valueOf(info.getPerformanceTestResults().values().size()) : null;
            }
            case 8: {
                return () -> this.openAction.accept(id);
            }
            case 9: {
                return () -> this.redoAction.accept(id);
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return COLUMN_CLASSES[column] == Runnable.class;
    }
}

