/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.model.details;

import at.jku.ssw.mevss.cerberus.ci.client.data.BenchmarkMetricPerformance;
import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.MetricResults;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.Average;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.Percentage;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import java.io.Closeable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class MetricsResultsTableModel
extends AbstractTableModel
implements TableModel,
Closeable {
    private static final long serialVersionUID = 1L;
    private final MetricResults results;
    private String normalizeColumn;
    private boolean errorsEnabled;
    private boolean integersOnly;
    private Thread worker = null;
    private final MetricResults.MetricListener listener = new MetricResults.MetricListener(){

        @Override
        public void newParameter(String parameter) {
            SwingUtilities.invokeLater(() -> MetricsResultsTableModel.this.fireTableStructureChanged());
        }

        @Override
        public void newBenchmark(String benchmark) {
            int index = MetricsResultsTableModel.this.results.getBenchmarks().indexOf(benchmark);
            SwingUtilities.invokeLater(() -> MetricsResultsTableModel.this.fireTableRowsInserted(index, index));
        }

        @Override
        public void newPerformance(BenchmarkMetricPerformance performance) {
            int row = MetricsResultsTableModel.this.results.getBenchmarks().indexOf(performance.getBenchmarkName());
            int col = 1 + MetricsResultsTableModel.this.results.getParameters().indexOf(performance.getParameter());
            SwingUtilities.invokeLater(() -> MetricsResultsTableModel.this.fireTableCellUpdated(row, col));
        }

        @Override
        public void metricFound(String metric) {
        }
    };

    public MetricsResultsTableModel(RemoteProjectAccess.CapabilityAccess access, BuildID id) {
        this.results = new MetricResults(access, id);
        this.results.addListener(this.listener);
    }

    public String getNormalizedColumn() {
        return this.normalizeColumn;
    }

    public boolean getErrorsEnabled() {
        return this.errorsEnabled;
    }

    public void normalizeColumn(String title) {
        this.normalizeColumn = title;
        this.integersOnly = true;
        SwingUtilities.invokeLater(() -> this.fireTableDataChanged());
    }

    public void enableErrors(boolean errorsEnabled) {
        this.errorsEnabled = errorsEnabled;
        SwingUtilities.invokeLater(() -> this.fireTableDataChanged());
    }

    @Override
    public void close() {
        this.clear(false);
        this.results.close();
    }

    private synchronized void clear(boolean keepMetaData) {
        if (this.worker != null) {
            this.worker.interrupt();
            try {
                this.worker.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.worker = null;
        }
        this.results.clear(keepMetaData);
        this.normalizeColumn = null;
        this.integersOnly = true;
        SwingUtilities.invokeLater(() -> this.fireTableDataChanged());
        SwingUtilities.invokeLater(() -> this.fireTableStructureChanged());
    }

    public synchronized void reset(String test, String metric, boolean force) throws InterruptedException {
        boolean metricChanged;
        boolean testChanged = test != null && !test.equals(this.results.getTest());
        boolean bl = metricChanged = metric != null && !metric.equals(this.results.getMetric());
        if (test == null) {
            this.clear(false);
        } else if (force || testChanged || metricChanged) {
            this.clear(!testChanged);
            this.worker = new Thread(() -> {
                try {
                    if (testChanged) {
                        this.results.fillMetaData();
                        this.results.downloadFolder();
                    }
                    this.results.parseDownloadFolder();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            });
            this.worker.setDaemon(true);
        } else {
            return;
        }
        this.results.setTest(test);
        this.results.setMetric(metric);
        if (this.worker != null) {
            this.worker.start();
        }
    }

    @Override
    public int getColumnCount() {
        return 2 + this.results.getParameters().size();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Suite";
            }
            case 1: {
                return "Benchmark";
            }
        }
        return this.results.getParameters().get(column - 2);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return column < 2 ? String.class : (this.normalizeColumn != null || this.errorsEnabled ? Average.class : (this.integersOnly ? Long.class : Double.class));
    }

    @Override
    public int getRowCount() {
        return this.results.getBenchmarks().size();
    }

    @Override
    public Object getValueAt(int r, int c) {
        String benchmark = this.results.getBenchmarks().get(r);
        switch (c) {
            case 0: {
                return benchmark.substring(0, benchmark.indexOf(32));
            }
            case 1: {
                return benchmark.substring(benchmark.indexOf(32) + 1, benchmark.length());
            }
        }
        String parameter = this.results.getParameters().get(c - 2);
        Average<Number> result = this.getValue(benchmark, parameter);
        if (Double.isNaN(((Number)result.value).doubleValue())) {
            return null;
        }
        if (this.normalizeColumn != null) {
            Average<Double> reference = this.getValue(benchmark, this.normalizeColumn);
            if (Double.isNaN((Double)reference.value) || (Double)reference.value == 0.0) {
                return null;
            }
            result = new Average<Double>(((Number)result.value).doubleValue() / (Double)reference.value, ((Number)result.errorDown).doubleValue() / (Double)reference.value, ((Number)result.errorUp).doubleValue() / (Double)reference.value);
        }
        if (this.integersOnly) {
            boolean bl = this.integersOnly = ((Number)result.value).doubleValue() == (double)((Number)result.value).longValue();
            if (!this.integersOnly) {
                SwingUtilities.invokeLater(() -> this.fireTableDataChanged());
            }
        }
        if (this.integersOnly) {
            result = new Average<Long>(((Number)result.value).longValue(), ((Number)result.errorDown).longValue(), ((Number)result.errorUp).longValue());
        }
        if (this.normalizeColumn != null) {
            result = new Average<Percentage>(new Percentage((Number)result.value), new Percentage((Number)result.errorDown), new Percentage((Number)result.errorUp));
        }
        if (this.errorsEnabled) {
            return result;
        }
        return result.value;
    }

    private Average<Double> getValue(String benchmark, String parameter) {
        return this.results.getValue(benchmark, parameter);
    }
}

