/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.model.details;

import at.jku.ssw.mevss.cerberus.ci.client.data.BenchmarkMetricPerformance;
import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.MetricResults;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class MetricsNameTableModel
extends AbstractTableModel
implements TableModel,
Closeable {
    private static final long serialVersionUID = 1L;
    private final Set<String> metrics;
    private final Map<Integer, String> rows;
    private MetricResults results;
    private Thread worker;
    private final MetricResults.MetricListener listener = new MetricResults.MetricListener(){

        @Override
        public void newParameter(String parameter) {
        }

        @Override
        public void newBenchmark(String benchmark) {
        }

        @Override
        public void newPerformance(BenchmarkMetricPerformance performance) {
        }

        @Override
        public void metricFound(String metric) {
            MetricsNameTableModel.this.add(metric);
        }
    };

    public MetricsNameTableModel(RemoteProjectAccess.CapabilityAccess access, BuildID id) {
        this.metrics = Collections.synchronizedSet(new HashSet());
        this.rows = Collections.synchronizedMap(new HashMap());
        this.results = new MetricResults(access, id);
        this.results.addListener(this.listener);
    }

    @Override
    public void close() {
        this.clear();
    }

    public synchronized void clear() {
        this.metrics.clear();
        this.rows.clear();
        SwingUtilities.invokeLater(() -> this.fireTableDataChanged());
    }

    public synchronized void add(String metric) {
        if (this.metrics.contains(metric)) {
            return;
        }
        this.metrics.add(metric);
        int row = this.rows.size();
        this.rows.put(row, metric);
        SwingUtilities.invokeLater(() -> this.fireTableRowsInserted(row, row));
    }

    @Override
    public synchronized void fireTableDataChanged() {
        super.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int column) {
        return "Metric";
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int r, int c) {
        return this.rows.get(r);
    }

    public Object get(int selectedRow) {
        return this.getValueAt(selectedRow, 0);
    }

    public void reset(String selectedTestName) {
        boolean testChanged;
        boolean bl = testChanged = selectedTestName != null && !selectedTestName.equals(this.results.getTest());
        if (selectedTestName == null) {
            if (this.worker != null) {
                this.worker.interrupt();
                try {
                    this.worker.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.worker = null;
            }
            this.results.clear(false);
            this.metrics.clear();
            this.results.setTest(selectedTestName);
            SwingUtilities.invokeLater(() -> this.fireTableDataChanged());
            SwingUtilities.invokeLater(() -> this.fireTableStructureChanged());
        } else if (testChanged) {
            if (this.worker != null) {
                this.worker.interrupt();
                try {
                    this.worker.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.worker = null;
            }
            this.results.clear(false);
            this.metrics.clear();
            this.results.setTest(selectedTestName);
            SwingUtilities.invokeLater(() -> this.fireTableDataChanged());
            SwingUtilities.invokeLater(() -> this.fireTableStructureChanged());
            this.worker = new Thread(() -> {
                this.results.fillMetaData();
                this.results.downloadFolder();
                try {
                    this.results.parseDownloadFolder();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            this.worker.setDaemon(true);
        }
        if (this.worker != null) {
            this.worker.start();
        }
    }
}

