/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.model.details;

import at.jku.ssw.mevss.cerberus.ci.client.Client;
import at.jku.ssw.mevss.cerberus.ci.client.data.BenchmarkMetricPerformance;
import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.errors.Errors;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.Average;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class MetricResults {
    private final CopyOnWriteArrayList<BenchmarkMetricPerformance> performances;
    private final CopyOnWriteArrayList<String> benchmarks;
    private final CopyOnWriteArrayList<String> parameters;
    private final CopyOnWriteArrayList<MetricListener> listener;
    private String test;
    private String metric;
    private final File downloadFolder;
    private final BuildID id;
    private final RemoteProjectAccess.CapabilityAccess access;
    private final Logger LOGGER = Logger.getLogger(this.getClass().getSimpleName());

    public MetricResults(RemoteProjectAccess.CapabilityAccess access, BuildID id) {
        this.performances = new CopyOnWriteArrayList();
        this.benchmarks = new CopyOnWriteArrayList();
        this.parameters = new CopyOnWriteArrayList();
        this.listener = new CopyOnWriteArrayList();
        this.id = id;
        this.access = access;
        File folder = null;
        try {
            folder = FileUtil.createTemporaryDirectory();
        }
        catch (IOException e) {
            Errors.show(null, "Metrics download folder could not be created", "Please try again", e);
        }
        this.downloadFolder = folder;
    }

    public void addListener(MetricListener l) {
        this.listener.add(l);
    }

    public void removeListener(MetricListener l) {
        this.listener.remove(l);
    }

    public void clear(boolean keepMetaData) {
        if (keepMetaData) {
            this.performances.stream().forEach(p -> p.reset());
        } else {
            this.test = null;
            this.metric = null;
            this.benchmarks.clear();
            this.parameters.clear();
            this.performances.clear();
            Arrays.stream(this.downloadFolder.listFiles()).forEach(FileUtil::deleteTree);
        }
    }

    public void close() {
        if (this.downloadFolder != null) {
            FileUtil.deleteTree(this.downloadFolder);
        }
        this.listener.clear();
    }

    public void fillMetaData() {
        this.access.getData(this.id, this.test, this::parseDataFileLine, true, true);
    }

    public void downloadFolder() {
        this.access.getDirectory(this.id, this.test, this.downloadFolder, ".log", ".result.best", ".result.global");
    }

    private void parseDataFileLine(String line) {
        if (line == null || line.length() == 0) {
            return;
        }
        try {
            String separator = line.contains(";") ? ";" : ",";
            String[] tokens = line.split(separator);
            String suite = tokens[0];
            String test = tokens[1];
            String parameter = tokens[2].equals("<default>") ? "" : tokens[2];
            String benchmarkName = suite + " " + test;
            BenchmarkMetricPerformance pBenchmark = new BenchmarkMetricPerformance(suite, test, parameter, this.metric);
            if (!this.parameters.contains(parameter)) {
                this.parameters.add(parameter);
                this.listener.forEach(x -> x.newParameter(parameter));
            }
            if (!this.benchmarks.contains(benchmarkName)) {
                this.benchmarks.add(benchmarkName);
                this.listener.forEach(x -> x.newBenchmark(benchmarkName));
            }
            if (!this.performances.contains(pBenchmark)) {
                this.performances.add(pBenchmark);
                this.listener.forEach(x -> x.newPerformance(pBenchmark));
            }
        }
        catch (Throwable t) {
            this.LOGGER.warning("Line could not be parsed in .data file.\n\"" + line + "\"");
        }
    }

    public void parseDownloadFolder() throws IOException {
        int logFileNr = 0;
        List<File> logFiles = Client.listf(this.downloadFolder, ".log");
        for (File logFile : logFiles) {
            this.LOGGER.fine("Log file #" + ++logFileNr + "(" + logFile + ")");
            String suite = null;
            String benchmarkName = null;
            String parameter = null;
            try (BufferedReader br = new BufferedReader(new FileReader(logFile));){
                String line = br.readLine();
                while (line != null) {
                    if (line.startsWith("suite")) {
                        suite = line.substring("suite=".length());
                    }
                    if (line.startsWith("benchmark")) {
                        benchmarkName = line.substring("benchmark=".length());
                    }
                    if (line.startsWith("parameters")) {
                        parameter = line.substring("parameters=".length());
                    }
                    line = br.readLine();
                }
            }
            if (suite == null || benchmarkName == null || parameter == null) {
                this.LOGGER.warning(".log file has incorrect format!");
                continue;
            }
            String fullBenchmarkName = suite + " " + benchmarkName;
            String localParameters = parameter;
            BenchmarkMetricPerformance performance = this.performances.stream().filter(x -> x.getBenchmarkName().equals(fullBenchmarkName) && x.getParameter().equals(localParameters)).findAny().orElse(null);
            if (performance == null) {
                this.LOGGER.warning("Benchmark performance not found but should exist!");
                assert (false);
            }
            int resultFileNr = 0;
            for (String extension : new String[]{".result.best", ".result.global"}) {
                this.LOGGER.fine("Result file #" + ++resultFileNr);
                String bestFilePath = logFile.getAbsolutePath().substring(0, logFile.getAbsolutePath().length() - ".log".length()) + extension;
                File bestFile = new File(bestFilePath);
                if (!bestFile.exists()) continue;
                try (BufferedReader br = new BufferedReader(new FileReader(bestFile));){
                    String line = br.readLine();
                    while (line != null) {
                        if (!(line = line.trim()).startsWith("#")) {
                            int splitIndex = line.indexOf(61);
                            if (splitIndex < 0) {
                                this.LOGGER.warning("Unparsable line (without \"=\") found: \"" + line + "\"");
                            } else {
                                String metric = line.substring(0, splitIndex);
                                this.listener.forEach(x -> x.metricFound(metric));
                                if (metric.equals(this.metric)) {
                                    String metricValueString = line.substring(metric.length() + 1);
                                    if (metricValueString.length() > 0) {
                                        Double val = Double.parseDouble(metricValueString);
                                        performance.addResult(val);
                                    }
                                    this.listener.forEach(x -> x.newPerformance(performance));
                                }
                            }
                        }
                        line = br.readLine();
                    }
                }
            }
        }
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public String getTest() {
        return this.test;
    }

    public String getMetric() {
        return this.metric;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public List<String> getBenchmarks() {
        return this.benchmarks;
    }

    public List<BenchmarkMetricPerformance> getPerformances() {
        return this.performances;
    }

    public Average<Double> getValue(String benchmark, String parameter) {
        BenchmarkMetricPerformance performance = this.getPerformances().stream().filter(x -> x.getBenchmarkName().equals(benchmark) && x.getParameter().equals(parameter)).findFirst().orElse(null);
        if (performance == null) {
            return new Average<Double>(Double.NaN, 0.0);
        }
        return performance.getMedianValue();
    }

    public static interface MetricListener {
        public void newParameter(String var1);

        public void newBenchmark(String var1);

        public void newPerformance(BenchmarkMetricPerformance var1);

        public void metricFound(String var1);
    }
}

