/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.model.details;

import java.util.stream.Stream;

public enum ExecutionResult {
    RUN_SUCCEEDED("succeeded", "run"),
    RUN_CRASHED("crashed", "run"),
    RUN_FAILED("failed", "run"),
    RUN_TIMEOUT("timeout", "run"),
    RUN_CRASHED_WITH_KNOWN_BUG("crashed_with_known_bug", "run"),
    TEST_SUCCEEDED("succeeded", "test"),
    TEST_CRASHED("crashed", "test"),
    TEST_FAILED("failed", "test"),
    TEST_TIMEOUT("timeout", "test"),
    TEST_CRASHED_WITH_KNOWN_BUG("crashed_with_known_bug", "test"),
    TEST_UNABLE("unable", "test");

    private String result;
    private String type;

    private ExecutionResult(String result, String type) {
        this.result = result;
        this.type = type;
    }

    public static ExecutionResult from(String type, String result) {
        return Stream.of(ExecutionResult.values()).filter(e -> e.type.equals(type) && e.result.equals(result)).findFirst().get();
    }

    public Boolean asBoolean() {
        switch (this) {
            case RUN_SUCCEEDED: 
            case TEST_SUCCEEDED: {
                return true;
            }
            case RUN_TIMEOUT: 
            case TEST_TIMEOUT: 
            case RUN_CRASHED: 
            case TEST_CRASHED: 
            case TEST_FAILED: {
                return false;
            }
            case RUN_FAILED: 
            case RUN_CRASHED_WITH_KNOWN_BUG: 
            case TEST_CRASHED_WITH_KNOWN_BUG: 
            case TEST_UNABLE: {
                return null;
            }
        }
        throw new IllegalArgumentException("Combination of type and result invalid");
    }

    public String toString() {
        return (this.type != null && this.type.length() > 0 ? this.type + ": " : "") + this.result;
    }
}

