/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.model.details;

import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.ActionResults;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.ExecutionResult;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class ActionResultsTableModel
extends AbstractTableModel
implements TableModel,
Closeable {
    private static final long serialVersionUID = -3489413296254704175L;
    private final ActionResults results;
    private Thread worker = null;
    private final ActionResults.ActionListener listener = new ActionResults.ActionListener(){

        @Override
        public void newParameter(String parameter) {
            SwingUtilities.invokeLater(() -> ActionResultsTableModel.this.fireTableStructureChanged());
            SwingUtilities.invokeLater(() -> ActionResultsTableModel.this.fireTableDataChanged());
        }

        @Override
        public void newBenchmark(String benchmark) {
            int index = ActionResultsTableModel.this.results.getBenchmarks().indexOf(benchmark);
            SwingUtilities.invokeLater(() -> ActionResultsTableModel.this.fireTableRowsInserted(index, index));
        }

        @Override
        public void newResult(String benchmark, String parameter) {
            int rowId = ActionResultsTableModel.this.results.getBenchmarks().indexOf(benchmark);
            int colId = ActionResultsTableModel.this.results.getParameters().indexOf(parameter) + 1;
            SwingUtilities.invokeLater(() -> ActionResultsTableModel.this.fireTableCellUpdated(rowId, colId));
            SwingUtilities.invokeLater(() -> ActionResultsTableModel.this.fireTableRowsUpdated(rowId, rowId));
        }
    };

    public ActionResultsTableModel(RemoteProjectAccess.CapabilityAccess access, BuildID id) {
        this.results = new ActionResults(access, id);
        this.results.addListener(this.listener);
    }

    @Override
    public void close() throws IOException {
        try {
            this.reset(null);
        }
        catch (InterruptedException __) {
            throw new InterruptedIOException();
        }
    }

    public void reset(String test) throws IOException, InterruptedException {
        if (this.worker != null) {
            this.worker.interrupt();
            this.worker.join();
        }
        this.results.clear();
        if (test != null) {
            this.worker = new Thread(() -> this.results.reset(test, false));
            this.worker.setDaemon(true);
            this.worker.start();
        }
        SwingUtilities.invokeLater(() -> this.fireTableStructureChanged());
        SwingUtilities.invokeLater(() -> this.fireTableDataChanged());
    }

    @Override
    public int getColumnCount() {
        return 2 + this.results.getParameters().size();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Suite";
            }
            case 1: {
                return "Benchmark";
            }
        }
        return this.results.getParameters().get(column - 2);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return column < 2 ? String.class : ExecutionResult[].class;
    }

    @Override
    public int getRowCount() {
        return this.results.getBenchmarks().size();
    }

    @Override
    public Object getValueAt(int r, int c) {
        String benchmark = this.results.getBenchmarks().get(r);
        switch (c) {
            case 0: {
                return benchmark.substring(0, benchmark.indexOf(32));
            }
            case 1: {
                return benchmark.substring(benchmark.indexOf(32) + 1, benchmark.length());
            }
        }
        Map<String, ExecutionResult[]> row = this.results.getResultsFor(benchmark);
        if (row == null) {
            return new ExecutionResult[0];
        }
        ExecutionResult[] value = row.get(this.results.getParameters().get(c - 2));
        if (value == null) {
            return new ExecutionResult[0];
        }
        return value;
    }

    public List<String> getParameters() {
        return this.results.getParameters();
    }

    public List<String> getBenchmarks() {
        return this.results.getBenchmarks();
    }
}

