/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.model.details;

import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.model.details.ExecutionResult;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class ActionResults {
    private final RemoteProjectAccess.CapabilityAccess access;
    private final BuildID id;
    private final Logger LOGGER;
    private final List<String> benchmarks;
    private final List<String> parameters;
    private final CopyOnWriteArrayList<ActionListener> listener;
    private final Map<String, Map<String, ExecutionResult[]>> values;

    public ActionResults(RemoteProjectAccess.CapabilityAccess access, BuildID id) {
        this.access = access;
        this.id = id;
        this.LOGGER = Logger.getLogger(this.getClass().getSimpleName());
        this.benchmarks = new ArrayList<String>();
        this.parameters = new ArrayList<String>();
        this.values = new HashMap<String, Map<String, ExecutionResult[]>>();
        this.listener = new CopyOnWriteArrayList();
    }

    public void clear() {
        this.benchmarks.clear();
        this.parameters.clear();
        this.values.clear();
    }

    public void reset(String test, boolean endReadingOnTimeout) {
        this.access.getData(this.id, test, this::parse, endReadingOnTimeout, true);
    }

    private void parse(String line) {
        if (line == null || line.length() == 0) {
            return;
        }
        try {
            String result;
            String splitter = line.contains(";") ? ";" : ",";
            String[] tokens = line.split(splitter);
            String benchmark = tokens[0] + " " + tokens[1];
            String parameter = tokens[2].equals("<default>") ? "" : tokens[2];
            String resultToken = tokens.length >= 4 ? tokens[3] : null;
            String type = resultToken != null ? resultToken.substring(0, resultToken.indexOf(61)) : null;
            String string = result = resultToken != null ? resultToken.substring(resultToken.indexOf(61) + 1, resultToken.length()) : null;
            if (!this.parameters.contains(parameter)) {
                this.parameters.add(parameter);
                this.listener.forEach(l -> l.newParameter(parameter));
            }
            if (!this.benchmarks.contains(benchmark)) {
                this.benchmarks.add(benchmark);
                this.listener.forEach(l -> l.newBenchmark(benchmark));
            }
            if (result != null) {
                ExecutionResult[] value;
                Map<String, ExecutionResult[]> row = this.values.get(benchmark);
                if (row == null) {
                    row = new HashMap<String, ExecutionResult[]>();
                    this.values.put(benchmark, row);
                }
                if ((value = row.get(parameter)) == null) {
                    value = new ExecutionResult[]{};
                }
                value = ArraysUtil.merge(ExecutionResult.class, value, {ExecutionResult.from(type, result)});
                row.put(parameter, value);
                this.listener.forEach(l -> l.newResult(benchmark, parameter));
            }
        }
        catch (Throwable t) {
            this.LOGGER.warning("Line could not be parsed in .data file.\n\"" + line + "\"");
        }
    }

    public List<String> getBenchmarks() {
        return this.benchmarks;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public Map<String, ExecutionResult[]> getResultsFor(String benchmark) {
        return this.values.get(benchmark);
    }

    public void addListener(ActionListener l) {
        this.listener.add(l);
    }

    public static interface ActionListener {
        public void newParameter(String var1);

        public void newBenchmark(String var1);

        public void newResult(String var1, String var2);
    }
}

