/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.model.details;

import at.jku.ssw.mevss.cerberus.ci.client.TestResult;
import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.data.SafeRemoteMap;
import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import java.io.Closeable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class ActionNamesTableModel
extends AbstractTableModel
implements TableModel,
Closeable {
    private static final long serialVersionUID = -7944763794935129732L;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Result"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, Boolean.class};
    private final RemoteProjectAccess projectAccess;
    private final RemoteProjectAccess.CapabilityAccess capabilityAccess;
    private final BuildID id;
    private TestResult[] tests;
    private final SafeRemoteMap.Listener<BuildID> listener = new SafeRemoteMap.Listener<BuildID>(){

        @Override
        public void added(BuildID key) {
        }

        @Override
        public void removed(BuildID key) {
            if (key.equals(ActionNamesTableModel.this.id)) {
                ActionNamesTableModel.this.close();
            }
        }

        @Override
        public void changed(BuildID key) {
            if (key.equals(ActionNamesTableModel.this.id)) {
                ActionNamesTableModel.this.update();
            }
        }

        @Override
        public void closed() {
        }
    };

    public ActionNamesTableModel(RemoteProjectAccess data, BuildID id, Capability responsibility) {
        this.projectAccess = data;
        this.id = id;
        switch (responsibility) {
            case FUNCTIONAL_TEST: {
                this.capabilityAccess = data.testAccess;
                break;
            }
            case PERFORMANCE_TEST: {
                this.capabilityAccess = data.performanceAccess;
                break;
            }
            default: {
                this.capabilityAccess = null;
            }
        }
        this.tests = this.capabilityAccess != null ? (TestResult[])this.capabilityAccess.getResults(id).entrySet().stream().map(e -> new TestResult((String)e.getKey(), (Boolean)e.getValue())).sorted((t1, t2) -> t1.name.compareTo(t2.name)).toArray(TestResult[]::new) : new TestResult[0];
        data.addListener(this.listener);
    }

    @Override
    public void close() {
        this.projectAccess.removeListener(this.listener);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return COLUMN_CLASSES[column];
    }

    private void update() {
        for (int i = 0; i < this.tests.length; ++i) {
            String test = this.tests[i].name;
            Boolean result = this.capabilityAccess.getResults(this.id).get(test);
            if (this.tests[i].result == result || result != null && result.equals(this.tests[i])) continue;
            this.tests[i] = new TestResult(this.tests[i].name, result);
            int invokeI = i;
            SwingUtilities.invokeLater(() -> this.fireTableCellUpdated(invokeI, 1));
        }
    }

    @Override
    public int getRowCount() {
        return this.tests.length;
    }

    public TestResult get(int row) {
        return this.tests[row];
    }

    @Override
    public Object getValueAt(int row, int column) {
        TestResult obj = this.get(row);
        switch (column) {
            case 0: {
                return obj.name;
            }
            case 1: {
                return obj.result;
            }
        }
        assert (false);
        return null;
    }
}

