/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.filechooser;

import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class JFileChooserUtil {
    public static void chooseFileAndSave(Component parent, boolean directory, String template, Action action) {
        File file = JFileChooserUtil.chooseFileForSave(parent, directory, template);
        if (file != null) {
            Thread thread = new Thread(() -> JFileChooserUtil.run(action, file, directory), "Save " + file + " Worker");
            thread.start();
        }
    }

    private static void run(Action action, File file, boolean directory) {
        try {
            action.run(file);
            int result = JOptionPane.showConfirmDialog(null, "Saving " + file + " finished!\n\nDo you want to " + (directory ? "show the directory in explorer?" : "open the file?"), "Save", 0);
            if (result == 0) {
                Desktop.getDesktop().open(file);
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace(System.err);
            JOptionPane.showMessageDialog(null, "Saving " + file + " failed!\n\t" + ioe, "Error", 0);
        }
    }

    public static File chooseFileForSave(Component parent, boolean directory, String template) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(directory ? 1 : 0);
        chooser.setSelectedFile(new File(template));
        if (chooser.showSaveDialog(null) == 0) {
            File file = chooser.getSelectedFile();
            if (file.exists()) {
                if (directory == file.isDirectory()) {
                    int result = -1;
                    if (file.isDirectory()) {
                        if (file.list().length > 0) {
                            result = JOptionPane.showConfirmDialog(null, "Directory not empty, do you want to clear it?", "Save File Error", 0, 3);
                            if (result == 0) {
                                FileUtil.deleteTree(file);
                            } else {
                                file = null;
                            }
                        }
                    } else {
                        result = JOptionPane.showConfirmDialog(null, "File already exists, do you want to override it?", "Save File Error", 0, 3);
                        if (result == 0) {
                            FileUtil.deleteTree(file);
                        } else {
                            file = null;
                        }
                    }
                } else {
                    JOptionPane.showConfirmDialog(null, "File already exists, and does not match required type (regular file, directory)!", "Save File Error", 0, 0);
                    file = null;
                }
            }
            return file;
        }
        return null;
    }

    public static String generatePath(String projectName, String id, String type, String sub, String extension) {
        StringBuilder path = new StringBuilder();
        if (projectName != null) {
            path.append(projectName.replace(" ", "-"));
            path.append("_");
        }
        if (id != null) {
            path.append(id.replace(" ", "-"));
            path.append("_");
        }
        if (type != null) {
            path.append(type.replace(" ", "-"));
            path.append("_");
        }
        if (sub != null) {
            path.append(sub.replace(" ", "-"));
            path.append("_");
        }
        assert (path.length() > 0) : "File name not set!";
        if (path.charAt(path.length() - 1) == '_') {
            path.deleteCharAt(path.length() - 1);
        }
        if (extension != null) {
            path.append(extension.replace(" ", "-"));
        }
        return path.toString();
    }

    public static interface Action {
        public void run(File var1) throws Exception;
    }
}

