/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.data;

import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class SafeRemoteMap<K, V>
implements AutoCloseable {
    private final Object lock = new Object();
    private final List<K> keys = new ArrayList<K>();
    private final Map<K, V> values = new HashMap();
    private final List<K> queue = new LinkedList<K>();
    private final List<Listener<K>> listeners = Collections.synchronizedList(new CopyOnWriteArrayList());
    private final Class<K> clazz;
    protected final Thread.UncaughtExceptionHandler handler;
    private final Thread worker;

    public SafeRemoteMap(Class<K> clazz, Thread.UncaughtExceptionHandler handler) {
        this.clazz = clazz;
        this.handler = handler;
        this.worker = new Thread(this::run, "SafeDataRemoteAccess Worker");
        this.worker.setDaemon(true);
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        this.worker.interrupt();
        Object object = this.lock;
        synchronized (object) {
            this.listeners.forEach(l -> l.closed());
            this.lock.notifyAll();
        }
        this.worker.join();
    }

    public void addListener(Listener<K> l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeListener(Listener<K> l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.keys.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K getKey(int index) {
        Object object = this.lock;
        synchronized (object) {
            return this.keys.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K[] getKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.keys.stream().toArray(l -> ArraysUtil.create(this.clazz, l));
        }
    }

    public V getValue(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                while (true) {
                    V value;
                    if ((value = this.tryGetValue(key)) != null) {
                        return value;
                    }
                    this.queue.add(key);
                    this.lock.notifyAll();
                    this.lock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V tryGetValue(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.worker.isInterrupted()) {
                return null;
            }
            return this.values.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOf(K key) {
        Object object = this.lock;
        synchronized (object) {
            return this.keys.indexOf(key);
        }
    }

    private void run() {
        assert (this.worker == Thread.currentThread());
        while (!this.worker.isInterrupted()) {
            try {
                this.runOnce();
            }
            catch (InterruptedException e) {
                this.worker.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnce() throws InterruptedException {
        V value;
        Object key = null;
        Object object = this.lock;
        synchronized (object) {
            while (this.queue.isEmpty()) {
                this.lock.wait();
            }
            key = this.queue.remove(0);
            if (this.values.containsKey(key)) {
                return;
            }
        }
        try {
            value = this.load(key);
        }
        catch (RemoteException re) {
            this.handler.uncaughtException(Thread.currentThread(), re);
            value = null;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.keys.contains(key)) {
                this.values.put(key, value);
                this.lock.notifyAll();
            }
        }
    }

    protected abstract V load(K var1) throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(K key) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.keys.contains(key)) {
                this.keys.add(key);
                this.lock.notifyAll();
                this.listeners.stream().forEach(l -> l.added(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void change(K key) {
        Object object = this.lock;
        synchronized (object) {
            this.values.remove(key);
            this.lock.notifyAll();
            this.listeners.stream().forEach(l -> l.changed(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(K key) {
        Object object = this.lock;
        synchronized (object) {
            this.keys.remove(key);
            this.values.remove(key);
            this.queue.remove(key);
            this.lock.notifyAll();
            this.listeners.stream().forEach(l -> l.removed(key));
        }
    }

    public static interface Listener<K> {
        public void added(K var1);

        public void removed(K var1);

        public void changed(K var1);

        public void closed();
    }
}

