/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.data;

import at.jku.ssw.mevss.cerberus.ci.client.data.LogFileTransferProtocol;
import at.jku.ssw.mevss.cerberus.ci.client.data.SafeRemoteMap;
import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.interfaces.filetransfer.FileTransferProtocol;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BlameReport;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildInfo;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteCallbackable;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteMaster;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteProject;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.net.InterruptableSocket;
import at.jku.ssw.mevss.cerberus.ci.shared.rmi.RemoteImpl;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteProjectAccess
extends SafeRemoteMap<BuildID, BuildInfo> {
    private final Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private final String host;
    private final RemoteMaster master;
    private final RemoteProject project;
    private final RemoteBuildListener listener;
    private final Thread poller;
    public final BuildAccess buildAccess;
    public final TestAccess testAccess;
    public final PerformanceAccess performanceAccess;

    public RemoteProjectAccess(String host, RemoteMaster master, RemoteProject project, Thread.UncaughtExceptionHandler handler) throws RemoteException {
        super(BuildID.class, (t, e) -> {
            Logger.getLogger("cerberus.client.remote_access").log(Level.SEVERE, "unexpected error", e);
            handler.uncaughtException(t, e);
        });
        this.host = host;
        this.master = master;
        this.project = project;
        this.listener = new RemoteBuildListener(this);
        this.poller = new Thread(this::pollWithRetry, "RemoteBuildAccess Poller");
        this.buildAccess = new BuildAccess();
        this.testAccess = new TestAccess();
        this.performanceAccess = new PerformanceAccess();
        this.logger.info("initializing");
        this.poller.start();
    }

    @Override
    public void close() throws Exception {
        this.logger.info("closing");
        super.close();
        if (this.poller != null) {
            this.logger.fine("unpolling");
            this.poller.interrupt();
        } else {
            this.logger.fine("unlistening");
            this.project.removeListener(this.listener);
        }
        this.listener.dispose();
        this.logger.info("closed");
    }

    private void pollWithRetry() {
        while (!this.poller.isInterrupted()) {
            try {
                this.poll();
                break;
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "error", t);
                for (BuildID id : (BuildID[])this.getKeys()) {
                    this.remove(id);
                }
            }
        }
    }

    private void poll() {
        assert (Thread.currentThread() == this.poller);
        try {
            this.logger.info("fetching initial data");
            for (BuildID id : this.project.getBuilds()) {
                this.listener.buildCreated(id);
            }
            this.logger.info("checking for callback");
            RemoteCallbackable.RemoteCallback callback = new RemoteCallbackable.RemoteCallback(){

                @Override
                public void call() throws RemoteException {
                }
            };
            UnicastRemoteObject.exportObject((Remote)callback, 0);
            boolean canCallback = this.master.canCallback(callback);
            UnicastRemoteObject.unexportObject(callback, true);
            if (canCallback) {
                this.logger.info("can callback, listening");
                this.project.addListener(this.listener);
                this.logger.info("refetching initial data");
                for (BuildID id : this.project.getBuilds()) {
                    this.listener.buildCreated(id);
                }
                return;
            }
            this.logger.info("cannot callback, polling");
            Logger logger = Logger.getLogger(this.logger.getName() + ".poller");
            logger.info("running");
            while (!this.poller.isInterrupted()) {
                logger.info("checking");
                HashSet set = new HashSet(Arrays.asList(super.getKeys()));
                logger.fine("fetching builds");
                for (BuildID id : this.project.getBuilds()) {
                    assert (id != null);
                    if (set.contains(id)) {
                        logger.fine("found pre-existing build, sending artificial changed event");
                        BuildInfo newInfo = this.load(id);
                        if (!newInfo.containsMore((BuildInfo)this.getValue(id))) continue;
                        this.listener.buildChanged(id);
                        continue;
                    }
                    logger.fine("found new build, sending artificial create event");
                    this.listener.buildCreated(id);
                }
                try {
                    logger.info("sleeping");
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    logger.info("interrupted, re-interrupting");
                    this.poller.interrupt();
                }
            }
        }
        catch (RemoteException e) {
            this.handler.uncaughtException(this.poller, e);
        }
    }

    public String getName() {
        try {
            return this.project.getName();
        }
        catch (RemoteException e) {
            this.handler.uncaughtException(Thread.currentThread(), e);
            return null;
        }
    }

    public BuildID[] getEnvironments() {
        try {
            this.logger.info("fetching environments");
            BuildID[] envs = this.project.getEnvironments();
            this.logger.info("fetched " + envs.length + " environments");
            return envs;
        }
        catch (RemoteException e) {
            this.handler.uncaughtException(Thread.currentThread(), e);
            return new BuildID[0];
        }
    }

    public BuildID[] getBuilds() {
        try {
            this.logger.info("fetching tests");
            BuildID[] builds = this.project.getBuilds();
            this.logger.info("fetched " + builds.length + " builds");
            return builds;
        }
        catch (RemoteException e) {
            this.handler.uncaughtException(Thread.currentThread(), e);
            return new BuildID[0];
        }
    }

    public String[] getFunctionalTests() {
        try {
            this.logger.info("fetching tests");
            String[] tests = this.project.getFunctionalTests();
            this.logger.info("fetched " + tests.length + " performance tests");
            return tests;
        }
        catch (RemoteException e) {
            this.handler.uncaughtException(Thread.currentThread(), e);
            return new String[0];
        }
    }

    public String[] getPerformanceTests() {
        try {
            this.logger.info("fetching performance tests");
            String[] tests = this.project.getPerformanceTests();
            this.logger.info("fetched " + tests.length + " tests");
            return tests;
        }
        catch (RemoteException e) {
            this.handler.uncaughtException(Thread.currentThread(), e);
            return new String[0];
        }
    }

    @Override
    protected BuildInfo load(BuildID id) throws RemoteException {
        this.logger.info("fetching information about " + id);
        BuildInfo info = this.project.getBuildInfo(id);
        this.logger.info("fetched information about " + id);
        return info;
    }

    public void startBuild(String name, BuildID[] envs, String[] actions, boolean deploy) {
        try {
            this.logger.info("starting task on " + Arrays.toString(envs) + " with actions " + actions);
            this.project.runTask(name, envs, actions, deploy);
            this.logger.info("started task");
        }
        catch (RemoteException e) {
            this.handler.uncaughtException(Thread.currentThread(), e);
        }
    }

    public void blameAndNotify(long id, String suspect) {
        try {
            this.project.tryBlameAndNotify(id, suspect);
        }
        catch (RemoteException e) {
            this.handler.uncaughtException(Thread.currentThread(), e);
        }
    }

    private BuildID getLatestBuildForEnv(BuildID env) {
        try {
            return this.project.getLatestBuild(env);
        }
        catch (RemoteException e) {
            this.handler.uncaughtException(Thread.currentThread(), e);
            return null;
        }
    }

    private BuildID getLatestBuildWithActionRun(BuildID env, Capability test, String actionName) {
        try {
            return this.project.getLatestBuildWithActionRun(env, test, actionName);
        }
        catch (RemoteException e) {
            this.handler.uncaughtException(Thread.currentThread(), e);
            return null;
        }
    }

    public String getRunningTask() {
        try {
            String running = this.project.getRunningTask();
            return running == null ? "No task running" : running;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "Running task information not available";
        }
    }

    public class PerformanceAccess
    extends ActionAccess {
        PerformanceAccess() {
            super("performance");
        }

        @Override
        protected String[] getImpl() {
            return RemoteProjectAccess.this.getPerformanceTests();
        }

        @Override
        protected void getDirectoryImpl(BuildID id, String name, File dir, String ... file_extensions) {
            try {
                int ticket = RemoteProjectAccess.this.project.publishPerformanceTest(id, name, file_extensions);
                if (ticket > 0) {
                    this.downloadFileTree(ticket, dir);
                }
            }
            catch (IOException e) {
                RemoteProjectAccess.this.logger.log(Level.INFO, "Error on downloading folder. This mostly happens when the metrics tab is iterated fast.", e);
            }
        }

        @Override
        protected void getLogImpl(BuildID id, String name, LogListener sink, boolean timeout, boolean interruptable) {
            try {
                this.downloadString(RemoteProjectAccess.this.project.publishPerformanceTestLog(id, name), sink, timeout, interruptable);
            }
            catch (IOException e) {
                RemoteProjectAccess.this.handler.uncaughtException(Thread.currentThread(), e);
            }
        }

        @Override
        protected void getDataImpl(BuildID id, String name, LogListener sink, boolean timeout, boolean interruptable) {
            try {
                this.downloadString(RemoteProjectAccess.this.project.publishPerformanceTestData(id, name), sink, timeout, interruptable);
            }
            catch (IOException e) {
                RemoteProjectAccess.this.handler.uncaughtException(Thread.currentThread(), e);
            }
        }

        @Override
        protected Map<String, Boolean> getResultsImpl(BuildID id) {
            return ((BuildInfo)RemoteProjectAccess.this.getValue(id)).getPerformanceTestResults();
        }

        @Override
        protected BuildID getLatestResultsImpl(BuildID env, String actionName) {
            return RemoteProjectAccess.this.getLatestBuildWithActionRun(env, Capability.PERFORMANCE_TEST, actionName);
        }

        @Override
        protected BlameReport blameImpl(BuildID id, String name) {
            try {
                return RemoteProjectAccess.this.project.getPerformanceTestBlameReport(id, name);
            }
            catch (RemoteException e) {
                RemoteProjectAccess.this.handler.uncaughtException(Thread.currentThread(), e);
                return new BlameReport();
            }
        }

        @Override
        public HashMap<BuildID, HashMap<String, BuildID>> getLatestResults() {
            try {
                return RemoteProjectAccess.this.project.getLatestBuilds(Capability.PERFORMANCE_TEST);
            }
            catch (RemoteException e) {
                RemoteProjectAccess.this.handler.uncaughtException(Thread.currentThread(), e);
                return null;
            }
        }
    }

    public class TestAccess
    extends ActionAccess {
        TestAccess() {
            super("test");
        }

        @Override
        protected String[] getImpl() {
            return RemoteProjectAccess.this.getFunctionalTests();
        }

        @Override
        protected void getDirectoryImpl(BuildID id, String name, File dir, String ... file_extensions) {
            try {
                int ticket = RemoteProjectAccess.this.project.publishTest(id, name, file_extensions);
                if (ticket > 0) {
                    this.downloadFileTree(ticket, dir);
                }
            }
            catch (IOException e) {
                RemoteProjectAccess.this.logger.log(Level.INFO, "Error on downloading folder", e);
            }
        }

        @Override
        protected void getLogImpl(BuildID id, String name, LogListener sink, boolean timeout, boolean interruptable) {
            try {
                this.downloadString(RemoteProjectAccess.this.project.publishTestLog(id, name), sink, timeout, interruptable);
            }
            catch (IOException e) {
                RemoteProjectAccess.this.handler.uncaughtException(Thread.currentThread(), e);
            }
        }

        @Override
        protected void getDataImpl(BuildID id, String name, LogListener sink, boolean timeout, boolean interruptable) {
            try {
                this.downloadString(RemoteProjectAccess.this.project.publishTestData(id, name), sink, timeout, interruptable);
            }
            catch (IOException e) {
                RemoteProjectAccess.this.handler.uncaughtException(Thread.currentThread(), e);
            }
        }

        @Override
        protected Map<String, Boolean> getResultsImpl(BuildID id) {
            return ((BuildInfo)RemoteProjectAccess.this.getValue(id)).getTestResults();
        }

        @Override
        protected BuildID getLatestResultsImpl(BuildID env, String actionName) {
            return RemoteProjectAccess.this.getLatestBuildWithActionRun(env, Capability.FUNCTIONAL_TEST, actionName);
        }

        @Override
        protected BlameReport blameImpl(BuildID id, String name) {
            try {
                return RemoteProjectAccess.this.project.getTestBlameReport(id, name);
            }
            catch (RemoteException e) {
                RemoteProjectAccess.this.handler.uncaughtException(Thread.currentThread(), e);
                return new BlameReport();
            }
        }

        @Override
        public HashMap<BuildID, HashMap<String, BuildID>> getLatestResults() {
            try {
                return RemoteProjectAccess.this.project.getLatestBuilds(Capability.FUNCTIONAL_TEST);
            }
            catch (RemoteException e) {
                RemoteProjectAccess.this.handler.uncaughtException(Thread.currentThread(), e);
                return null;
            }
        }
    }

    public abstract class ActionAccess
    extends CapabilityAccess {
        ActionAccess(String accessName) {
            super(accessName);
        }

        public abstract HashMap<BuildID, HashMap<String, BuildID>> getLatestResults();
    }

    public class BuildAccess
    extends CapabilityAccess {
        BuildAccess() {
            super("build");
        }

        @Override
        protected String[] getImpl() {
            try {
                return RemoteProjectAccess.this.project.getSchedule();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return new String[]{"Build schedule information not available"};
            }
        }

        @Override
        protected void getDirectoryImpl(BuildID id, String name, File dir, String ... file_extensions) {
            try {
                int ticket = RemoteProjectAccess.this.project.publishBuild(id, file_extensions);
                if (ticket > 0) {
                    this.downloadFileTree(ticket, dir);
                }
            }
            catch (IOException e) {
                RemoteProjectAccess.this.logger.log(Level.INFO, "Error on downloading folder", e);
            }
        }

        @Override
        protected void getLogImpl(BuildID id, String name, LogListener sink, boolean timeout, boolean interruptable) {
            try {
                this.downloadString(RemoteProjectAccess.this.project.publishBuildLog(id), sink, timeout, interruptable);
            }
            catch (IOException e) {
                RemoteProjectAccess.this.handler.uncaughtException(Thread.currentThread(), e);
            }
        }

        @Override
        protected void getDataImpl(BuildID id, String name, LogListener sink, boolean timeout, boolean interruptable) {
        }

        @Override
        protected Map<String, Boolean> getResultsImpl(BuildID id) {
            HashMap<String, Boolean> res = new HashMap<String, Boolean>();
            res.put("build", ((BuildInfo)RemoteProjectAccess.this.getValue(id)).getBuildResult());
            return res;
        }

        @Override
        protected BuildID getLatestResultsImpl(BuildID env, String actionName) {
            return RemoteProjectAccess.this.getLatestBuildForEnv(env);
        }

        @Override
        protected BlameReport blameImpl(BuildID id, String name) {
            try {
                return RemoteProjectAccess.this.project.getBuildBlameReport(id);
            }
            catch (RemoteException e) {
                RemoteProjectAccess.this.handler.uncaughtException(Thread.currentThread(), e);
                return new BlameReport();
            }
        }
    }

    public abstract class CapabilityAccess {
        private final Logger logger = Logger.getLogger(this.getClass().getSimpleName());
        private final String accessName;

        CapabilityAccess(String accessName) {
            this.accessName = accessName;
        }

        public final String[] get() {
            this.logGet();
            String[] res = this.getImpl();
            return res;
        }

        protected abstract String[] getImpl();

        public final void getDirectory(BuildID id, String name, File dir, String ... file_extensions) {
            this.logGetDirectory(id);
            this.getDirectoryImpl(id, name, dir, file_extensions);
        }

        protected abstract void getDirectoryImpl(BuildID var1, String var2, File var3, String ... var4);

        public final void getLog(BuildID id, String name, LogListener sink, boolean timeout, boolean interruptable) {
            this.logGetLog(id);
            this.getLogImpl(id, name, sink, timeout, interruptable);
        }

        protected abstract void getLogImpl(BuildID var1, String var2, LogListener var3, boolean var4, boolean var5);

        public final void getData(BuildID id, String name, LogListener sink, boolean timeout, boolean interruptable) {
            this.logGetData(id);
            this.getDataImpl(id, name, sink, timeout, interruptable);
        }

        protected abstract void getDataImpl(BuildID var1, String var2, LogListener var3, boolean var4, boolean var5);

        public final Map<String, Boolean> getResults(BuildID id) {
            this.logGetResults(id);
            Map<String, Boolean> res = this.getResultsImpl(id);
            return res;
        }

        protected abstract Map<String, Boolean> getResultsImpl(BuildID var1);

        public final BuildID getLatestBuild(BuildID env, String actionName) {
            this.logGetLatesResults(env, actionName);
            BuildID res = this.getLatestResultsImpl(env, actionName);
            return res;
        }

        protected abstract BuildID getLatestResultsImpl(BuildID var1, String var2);

        public final void startBlame(BuildID id, String name, Consumer<BlameReport> consumer) {
            Thread worker = new Thread(() -> consumer.accept(this.blame(id, name)), "Blame " + id + " " + this.accessName + " Worker");
            worker.setDaemon(true);
            worker.start();
        }

        private final BlameReport blame(BuildID id, String name) {
            this.logger.info("blaming " + this.accessName + " error on " + id);
            BlameReport report = this.blameImpl(id, name);
            this.logger.info("blamed " + this.accessName + " error on " + id + " on " + Arrays.toString(report.getSuspects()));
            return report;
        }

        protected abstract BlameReport blameImpl(BuildID var1, String var2);

        private void logGet() {
            this.logger.info("downloading " + this.accessName.toUpperCase() + " name(s) of project " + RemoteProjectAccess.this.getName());
        }

        private void logGetLatesResults(BuildID env, String name) {
            this.logger.info("downloading latest " + this.accessName.toUpperCase() + " result with name " + name.toUpperCase() + " for env " + env.toString().toUpperCase());
        }

        private void logGetDirectory(BuildID id) {
            this.logger.info("downloading " + this.accessName.toUpperCase() + " directory of " + id);
        }

        private void logGetLog(BuildID id) {
            this.logger.info("downloading " + this.accessName.toUpperCase() + " log of " + id);
        }

        private void logGetData(BuildID id) {
            this.logger.info("downloading " + this.accessName.toUpperCase() + " data of " + id);
        }

        private void logGetResults(BuildID id) {
            this.logger.info("accessing " + this.accessName.toUpperCase() + " results of " + id);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void downloadString(int ticket, LogListener sink, boolean timeout, boolean interruptable) throws RemoteException, IOException {
            File dir = null;
            ObjectOutputStream out = null;
            ObjectInputStream in = null;
            try {
                try (InterruptableSocket socket = new InterruptableSocket(RemoteProjectAccess.this.host, RemoteProjectAccess.this.master.getFileServerPort(), timeout ? 1000 : 0);){
                    out = new ObjectOutputStream(socket.getOutputStream());
                    in = new ObjectInputStream(((Socket)socket).getInputStream());
                    out.writeInt(ticket);
                    out.flush();
                    dir = FileUtil.createTemporaryDirectory();
                    new LogFileTransferProtocol(String.valueOf(ticket), sink).read(null, dir, in);
                    out.close();
                    in.close();
                }
                FileUtil.deleteTree(dir);
            }
            catch (SocketTimeoutException e) {
                if (out != null) {
                    out.close();
                }
                if (in == null) return;
                in.close();
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (InterruptedIOException e2) {
                    if (!interruptable) throw e2;
                    if (out != null) {
                        out.close();
                    }
                    if (in == null) return;
                    in.close();
                    return;
                    catch (ClassNotFoundException e3) {
                        if ($assertionsDisabled) throw new IOException(e3);
                        throw new AssertionError((Object)"here be dragons");
                    }
                }
            }
            finally {
                FileUtil.deleteTree(dir);
            }
            return;
        }

        protected void downloadFileTree(int ticket, File dir) throws IOException {
            if (ticket == 0) {
                throw new IOException("Data unavailable on server!");
            }
            try (InterruptableSocket socket = new InterruptableSocket(RemoteProjectAccess.this.host, RemoteProjectAccess.this.master.getFileServerPort(), 10000);){
                ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
                ObjectInputStream in = new ObjectInputStream(((Socket)socket).getInputStream());
                out.writeInt(ticket);
                out.flush();
                new FileTransferProtocol(String.valueOf(ticket)).read(null, dir, in);
                out.close();
                in.close();
            }
            catch (ClassNotFoundException e) {
                assert (false) : "here be dragons";
                throw new IOException(e);
            }
            catch (InterruptedIOException e) {
                this.logger.info("File download interrupted");
                throw new IOException(e);
            }
        }
    }

    public static interface LogListener {
        public void log(String var1);
    }

    private static class RemoteBuildListener
    extends RemoteImpl<RemoteProjectAccess>
    implements RemoteProject.Listener {
        public RemoteBuildListener(RemoteProjectAccess inner) throws RemoteException {
            super(inner);
        }

        @Override
        public void buildCreated(BuildID id) throws RemoteException {
            ((RemoteProjectAccess)this.inner).logger.info("received created event, adding " + id);
            ((RemoteProjectAccess)this.inner).add(id);
        }

        @Override
        public void buildChanged(BuildID id) throws RemoteException {
            ((RemoteProjectAccess)this.inner).logger.info("received changed event, changing " + id);
            ((RemoteProjectAccess)this.inner).change(id);
        }

        @Override
        public void buildRemoved(BuildID id) throws RemoteException {
            ((RemoteProjectAccess)this.inner).logger.info("received remove event, removing " + id);
            ((RemoteProjectAccess)this.inner).remove(id);
        }
    }
}

