/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.data;

import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.interfaces.filetransfer.FileTransferProtocol;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class LogFileTransferProtocol
extends FileTransferProtocol {
    private final RemoteProjectAccess.LogListener sink;

    public LogFileTransferProtocol(String name, RemoteProjectAccess.LogListener sink) {
        super(name);
        this.sink = sink;
    }

    @Override
    protected OutputStream createOutputStream(File __) {
        return new OutputStream(){
            private final StringBuilder string = new StringBuilder();

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public void write(byte[] buf, int off, int len) throws IOException {
                this.string.append(new String(buf, off, len));
                this.flush();
            }

            @Override
            public void flush() throws IOException {
                super.flush();
                int index = this.string.indexOf("\n");
                while (index >= 0) {
                    String line = this.string.substring(0, index).toString();
                    LogFileTransferProtocol.this.sink.log(line);
                    this.string.replace(0, index + 1, "");
                    index = this.string.indexOf("\n");
                }
            }

            @Override
            public void close() throws IOException {
                this.flush();
                LogFileTransferProtocol.this.sink.log(this.string.toString());
                this.string.setLength(0);
                super.close();
            }
        };
    }
}

