/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.data;

import at.jku.ssw.mevss.cerberus.ci.client.renderer.Average;
import java.util.ArrayList;
import java.util.List;

public class BenchmarkMetricPerformance {
    private final String suite;
    private final String test;
    private final String parameter;
    private final String metric;
    private final List<Double> results;

    public BenchmarkMetricPerformance(String suite, String test, String config, String metric) {
        this.suite = suite;
        this.test = test;
        this.parameter = config;
        this.metric = metric;
        this.results = new ArrayList<Double>();
    }

    public String getBenchmarkName() {
        return this.suite + " " + this.test;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void reset() {
        this.results.clear();
    }

    public synchronized void addResult(Double d) {
        this.results.add(d);
    }

    public synchronized Average<Double> getMedianValue() {
        if (this.results.size() == 0) {
            return new Average<Double>(Double.NaN, 0.0);
        }
        double[] values = this.results.stream().mapToDouble(v -> v).sorted().toArray();
        double median = BenchmarkMetricPerformance.percentile(values, 0.5);
        double errorDown = median - BenchmarkMetricPerformance.percentile(values, 0.05);
        double errorUp = BenchmarkMetricPerformance.percentile(values, 0.95) - median;
        return new Average<Double>(median, errorDown, errorUp);
    }

    private static double percentile(double[] values, double percentile) {
        return values.length % 2 == 0 ? (values[(int)((double)values.length * percentile - 1.0)] + values[(int)((double)values.length * percentile - 0.0)]) / 2.0 : values[(int)((double)values.length * percentile)];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.metric == null ? 0 : this.metric.hashCode());
        result = 31 * result + (this.parameter == null ? 0 : this.parameter.hashCode());
        result = 31 * result + (this.suite == null ? 0 : this.suite.hashCode());
        result = 31 * result + (this.test == null ? 0 : this.test.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BenchmarkMetricPerformance other = (BenchmarkMetricPerformance)obj;
        if (this.metric == null ? other.metric != null : !this.metric.equals(other.metric)) {
            return false;
        }
        if (this.parameter == null ? other.parameter != null : !this.parameter.equals(other.parameter)) {
            return false;
        }
        if (this.suite == null ? other.suite != null : !this.suite.equals(other.suite)) {
            return false;
        }
        return !(this.test == null ? other.test != null : !this.test.equals(other.test));
    }
}

