/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client;

import at.jku.ssw.mevss.cerberus.ci.client.AutoConfig;
import at.jku.ssw.mevss.cerberus.ci.client.WindowClosedListener;
import at.jku.ssw.mevss.cerberus.ci.client.errors.Errors;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.DateRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.view.main.MainFrame;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildInfo;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteMaster;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteProject;
import java.io.File;
import java.net.SocketException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Client {
    private static Logger LOGGER = Logger.getLogger(Client.class.getSimpleName());
    private static ConnectionData LAST_CONNECTION;

    public static ConnectionData getConnection(String defaultconnection) {
        int port;
        String host;
        do {
            String input;
            host = null;
            port = -1;
            if (defaultconnection == null) {
                defaultconnection = AutoConfig.getOrElse("url", "127.0.0.1:1099");
            }
            if (defaultconnection.endsWith("!")) {
                input = defaultconnection.substring(0, defaultconnection.length() - 1);
            } else {
                input = (String)JOptionPane.showInputDialog(null, "Connection data for master:", "Master", 3, null, null, defaultconnection);
                if (input == null) {
                    return null;
                }
            }
            if (input.contains(":")) {
                host = input.substring(0, input.indexOf(":"));
                String portString = input.substring(input.indexOf(":") + 1, input.length());
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException nfe) {
                    Errors.show(null, "Input Error", "Illegal value for port! (" + portString + ")", nfe);
                }
                continue;
            }
            Errors.show(null, "Input Error", "Illegal syntax for connection data!", null);
        } while (host == null || port < 0);
        AutoConfig.set("url", host + ":" + port);
        LAST_CONNECTION = new ConnectionData(host, port);
        return LAST_CONNECTION;
    }

    public static String createDetailsHeader(BuildID id, BuildInfo info) {
        return id.getOS() + " " + id.getArchitecture() + " " + id.getAddressLength() + " \"" + info.getName() + "\" " + DateRenderer.FORMAT.format(info.getTime());
    }

    public static String createSuspectList(String[] suspects) {
        if (suspects.length == 0) {
            return "unknown";
        }
        StringBuilder string = new StringBuilder();
        for (int i = 0; i < suspects.length; ++i) {
            if (i > 0) {
                string.append(", ");
            }
            string.append(suspects[i]);
        }
        return string.toString();
    }

    public static List<File> listf(File directory, String ending) {
        ArrayList<File> files = new ArrayList<File>();
        File[] fList = directory.listFiles();
        for (File file : fList = fList != null ? fList : new File[]{}) {
            if (file.isFile()) {
                if (ending != null && !file.getName().endsWith(ending)) continue;
                files.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            files.addAll(Client.listf(file, ending));
        }
        return files;
    }

    public static void startMainWithLastKnowConnection() {
        if (LAST_CONNECTION != null) {
            try {
                Client.startMain(Client.LAST_CONNECTION.host, Client.getMaster(LAST_CONNECTION), null);
            }
            catch (SocketException | NotBoundException e) {
                Errors.show(null, "Error", "Could not start client", e);
            }
        } else {
            LOGGER.warning("startMainWithLastKnowConnection may only be used after at least one call of getConnection and getMaser");
        }
    }

    public static void startMain(String host, RemoteMaster master) {
        Client.startMain(host, master, null);
    }

    public static void startMain(String host, RemoteMaster master, String projectName) {
        RemoteProject project = Client.getProject(master, projectName);
        if (project == null) {
            return;
        }
        Thread thread = new Thread(() -> Client.mainSafely(host, master, project), "Main");
        thread.start();
    }

    public static RemoteProject getProject(RemoteMaster master, String name) {
        try {
            RemoteProject project = null;
            if (name == null) {
                name = AutoConfig.get("project");
            }
            LOGGER.info("accessing project");
            if (name != null) {
                project = master.getProject(name);
            }
            if (project == null) {
                Object[] names = master.getProjects();
                if (names.length == 1) {
                    name = names[0];
                } else {
                    name = (String)JOptionPane.showInputDialog(null, "Open Project", "Project", 3, null, names, null);
                    if (name == null) {
                        return null;
                    }
                }
                project = master.getProject(name);
            }
            AutoConfig.set("project", name);
            return project;
        }
        catch (RemoteException e) {
            Errors.show(null, "Connection Error", "Error selecting project!", e);
            return null;
        }
    }

    public static void mainSafely(String host, RemoteMaster master, RemoteProject project) {
        try {
            JFrame frame = MainFrame.create(host, master, project);
            WindowClosedListener listener = new WindowClosedListener();
            frame.addWindowListener(listener);
            listener.waitForClosed();
        }
        catch (Exception e) {
            Errors.show(null, "Error", "Unexepcted error!", e);
        }
    }

    public static RemoteMaster getMaster(ConnectionData connection) throws NotBoundException, SocketException {
        try {
            LOGGER.info("connecting to master");
            Registry registry = LocateRegistry.getRegistry(connection.host, connection.port);
            return (RemoteMaster)registry.lookup("CI_Master");
        }
        catch (RemoteException re) {
            Errors.show(null, "Connection Error", "Cannot reach master at " + connection.host + ":" + connection.port + "!", re);
            return null;
        }
    }

    public static class ConnectionData {
        public final String host;
        public final int port;

        public ConnectionData(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }
}

