/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client;

import at.jku.ssw.mevss.cerberus.ci.client.Client;
import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.util.JCloseableTabbedPane;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BlameReport;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BlameReportProblem;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class BlamingHelper {
    private static Component createBlameReport(int id, String problem, String[] reasons) {
        JLabel header = new JLabel(problem);
        JTextArea area = new JTextArea();
        area.setBorder(new TitledBorder("Reasons"));
        area.setEditable(false);
        for (int i = 0; i < reasons.length; ++i) {
            area.append(reasons[i]);
            area.append("\n\n");
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(String.valueOf("Problem " + id)));
        panel.add((Component)header, "North");
        panel.add((Component)area, "Center");
        return panel;
    }

    public static void openBlameReport(JCloseableTabbedPane tabs, RemoteProjectAccess data, BuildID id, BlameReport report) {
        String header = BlamingHelper.createBlameReportHeader(id, (BuildInfo)data.getValue(id));
        if (!tabs.selectTab(header)) {
            JComponent content = BlamingHelper.createBlameReport(data, id, report);
            tabs.addTab(header, null, content, true, null);
        }
    }

    private static String createBlameReportHeader(BuildID id, BuildInfo info) {
        return "Blame Report for " + Client.createDetailsHeader(id, info);
    }

    private static JComponent createBlameReport(RemoteProjectAccess data, BuildID id, BlameReport report) {
        JLabel header = new JLabel("Suspects are " + Client.createSuspectList(report.getSuspects()) + ".");
        JPanel list = new JPanel();
        list.setLayout(new BoxLayout(list, 1));
        for (String suspect : report.getSuspects()) {
            list.add(BlamingHelper.createBlameReport(data, id, suspect, report.getProblemsCausedBy(suspect)));
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder("Suspects"));
        panel.add((Component)header, "North");
        panel.add((Component)new JScrollPane(list), "Center");
        return panel;
    }

    private static Component createBlameReport(RemoteProjectAccess data, BuildID id, String suspect, BlameReportProblem[] problems) {
        JButton notify = new JButton("Reblame and Notify");
        notify.addActionListener(e -> BlamingHelper.startBlameAndNotify(data, id, suspect));
        JPanel control = new JPanel(new BorderLayout());
        control.add((Component)notify, "East");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder("Suspect " + suspect));
        panel.add(control);
        int i = 0;
        for (BlameReportProblem problem : problems) {
            panel.add(BlamingHelper.createBlameReport(i++, problem.problem, problem.changes));
        }
        return panel;
    }

    private static void startBlameAndNotify(RemoteProjectAccess data, BuildID id, String suspect) {
        Thread thread = new Thread(() -> data.blameAndNotify(id.getID(), suspect));
        thread.setDaemon(true);
        thread.start();
    }
}

