/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AutoConfig {
    private static final String NAME = "auto.config";
    private static final Map<String, String> CONFIGS = new HashMap<String, String>();

    private static synchronized void dump() {
        try (FileWriter out = new FileWriter(NAME);){
            for (String key : CONFIGS.keySet()) {
                String value = CONFIGS.get(key);
                if (value == null) continue;
                out.write(key + "=" + value + "\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void set(String key, String value) {
        CONFIGS.put(key, value);
    }

    public static String get(String key) {
        return AutoConfig.getOrElse(key, null);
    }

    public static synchronized String getOrElse(String key, String backup) {
        String value = CONFIGS.get(key);
        if (value == null) {
            value = backup;
        }
        return value;
    }

    private AutoConfig() {
        throw new Error();
    }

    static {
        try (BufferedReader in = new BufferedReader(new FileReader(NAME));){
            String line = in.readLine();
            while (line != null) {
                if (!(line = line.trim()).startsWith("%") && line.length() > 0) {
                    int index = line.indexOf(61);
                    String key = line.substring(0, index);
                    String value = line.substring(index + 1, line.length());
                    AutoConfig.set(key, value);
                }
                line = in.readLine();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Runtime.getRuntime().addShutdownHook(new Thread(AutoConfig::dump));
    }
}

