/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.interfaces.rmi;

import java.io.Serializable;

public class BuildID
implements Serializable,
Comparable<BuildID> {
    private static final long serialVersionUID = 8296518313174204552L;
    private final long id;
    private final String os;
    private final String architecture;
    private final int addressLength;

    public BuildID(String os, String architecture, int addressLength) {
        this(0L, os, architecture, addressLength);
    }

    public BuildID(long id, String os, String architecture, int addressLength) {
        this.id = id;
        this.os = os;
        this.architecture = architecture;
        this.addressLength = addressLength;
    }

    public long getID() {
        return this.id;
    }

    public String getOS() {
        return this.os;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public int getAddressLength() {
        return this.addressLength;
    }

    public int hashCode() {
        return Long.hashCode(this.id) ^ this.os.hashCode() ^ this.architecture.hashCode() ^ this.addressLength;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        BuildID that = (BuildID)other;
        return this.id == that.id && this.os.equals(that.os) && this.architecture.equals(that.architecture) && this.addressLength == that.addressLength;
    }

    @Override
    public int compareTo(BuildID that) {
        int diff = (int)Math.signum(this.id - that.id);
        if (diff != 0) {
            return diff;
        }
        diff = this.os.compareTo(that.os);
        if (diff != 0) {
            return diff;
        }
        diff = this.architecture.compareTo(that.architecture);
        if (diff != 0) {
            return diff;
        }
        diff = this.addressLength - that.addressLength;
        return diff;
    }

    public String toString() {
        return this.os + "_" + this.architecture + "_" + this.addressLength + (this.id != 0L ? "_" + this.id : "");
    }

    public String toIdSortedString() {
        return (this.id != 0L ? this.id + "_" : "") + this.os + "_" + this.architecture + "_" + this.addressLength;
    }

    public BuildID toEnv() {
        return this.id == 0L ? this : new BuildID(this.os, this.architecture, this.addressLength);
    }
}

