/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.indicator;

import at.jku.ssw.mevss.indicator.ApplicationIndicator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class LinuxGTKApplicationIndicator<T>
extends ApplicationIndicator<T> {
    private static long NEXT_ID = 0L;
    private static final Object LOCK = new Object();
    private static final Map<String, LinuxGTKApplicationIndicator<?>> INSTANCES = new HashMap();
    private final String id;
    private final long native_this;

    private static native void init();

    private static native void run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyAllAndShutdown() {
        Object object = LOCK;
        synchronized (object) {
            LinuxGTKApplicationIndicator.destroyAll();
            LinuxGTKApplicationIndicator.shutdown();
        }
    }

    private static void destroyAll() {
        INSTANCES.values().forEach(linuxGTKApplicationIndicator -> linuxGTKApplicationIndicator.destroy());
    }

    private static native void shutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public LinuxGTKApplicationIndicator(String string, T[] TArray, File[] fileArray, String[] stringArray, File[] fileArray2, ApplicationIndicator.MenuItem<T> ... menuItemArray) {
        super(string, TArray, fileArray, stringArray, fileArray2, menuItemArray);
        Object object = LOCK;
        synchronized (object) {
            this.id = this.getClass().getName() + "" + String.valueOf(NEXT_ID++);
            this.native_this = LinuxGTKApplicationIndicator.create(this.id, string, "/");
            INSTANCES.put(this.id, this);
        }
    }

    public String getId() {
        return this.id;
    }

    private static native long create(String var0, String var1, String var2);

    protected void finalize() {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        Object object = LOCK;
        synchronized (object) {
            LinuxGTKApplicationIndicator.destroy(this.native_this);
        }
    }

    private static native void destroy(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run_action(String string) {
        try {
            Object object = LOCK;
            synchronized (object) {
                int n = string.lastIndexOf(":");
                String string2 = string.substring(0, n);
                int n2 = Integer.parseInt(string.substring(n + 1, string.length()));
                LinuxGTKApplicationIndicator<?> linuxGTKApplicationIndicator = INSTANCES.get(string2);
                if (linuxGTKApplicationIndicator == null) {
                    return;
                }
                for (ApplicationIndicator.MenuItem menuItem : linuxGTKApplicationIndicator.state_actions) {
                    if (menuItem.id != n2) continue;
                    new Thread(menuItem.runnable).start();
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setVisible0(boolean bl) {
        Object object = LOCK;
        synchronized (object) {
            if (bl) {
                this.show();
            } else {
                this.hide();
            }
        }
    }

    private native void hide();

    private native void show();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isVisible0() {
        Object object = LOCK;
        synchronized (object) {
            return this.isShown();
        }
    }

    private native boolean isShown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setState0(T t, File file, String string, ApplicationIndicator.MenuItem<T>[] menuItemArray) {
        String string2 = file.getAbsolutePath();
        Object object = LOCK;
        synchronized (object) {
            this.setIcon(string2);
            this.setMenu(menuItemArray);
        }
        if (this.isVisible()) {
            try {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/notify-send", "--icon=" + string2, this.title, string.toString()});
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    private native void setIcon(String var1);

    private native void setMenu(ApplicationIndicator.MenuItem<T>[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replaceIcon0(File file) {
        Object object = LOCK;
        synchronized (object) {
            this.setIcon(file.getAbsolutePath());
        }
    }

    static {
        System.loadLibrary("jappindicator");
        Thread thread = new Thread(() -> {
            LinuxGTKApplicationIndicator.init();
            LinuxGTKApplicationIndicator.run();
        }, LinuxGTKApplicationIndicator.class.getName() + " GTK Thread");
        thread.setPriority(10);
        thread.setDaemon(true);
        thread.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            throw new ExceptionInInitializerError();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(LinuxGTKApplicationIndicator::destroyAllAndShutdown, LinuxGTKApplicationIndicator.class.getName() + " GTK Shutdown Thread"));
    }
}

