/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.indicator;

import at.jku.ssw.mevss.indicator.ApplicationIndicator;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class GenericApplicationIndicator<T>
extends ApplicationIndicator<T> {
    private final TrayIcon tray_icon;

    public GenericApplicationIndicator(String string, T[] TArray, File[] fileArray, String[] stringArray, File[] fileArray2, ApplicationIndicator.MenuItem<T>[] menuItemArray) {
        super(string, TArray, fileArray, stringArray, fileArray2, menuItemArray);
        try {
            this.tray_icon = new TrayIcon(ImageIO.read(fileArray[0]));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    protected void setVisible0(boolean bl) {
        if (bl && !this.isVisible()) {
            try {
                SystemTray.getSystemTray().add(this.tray_icon);
            }
            catch (AWTException aWTException) {
                throw new RuntimeException(aWTException);
            }
        } else if (!bl && this.isVisible()) {
            SystemTray.getSystemTray().remove(this.tray_icon);
        }
    }

    @Override
    protected boolean isVisible0() {
        return Arrays.stream(SystemTray.getSystemTray().getTrayIcons()).filter(trayIcon -> trayIcon == this.tray_icon).count() == 1L;
    }

    @Override
    protected void setState0(T t, File file, String string, ApplicationIndicator.MenuItem<T>[] menuItemArray) {
        try {
            this.tray_icon.setImage(this.getIcon(file));
            this.tray_icon.setToolTip(string);
            PopupMenu popupMenu = new PopupMenu();
            for (ApplicationIndicator.MenuItem<T> menuItem : menuItemArray) {
                MenuItem menuItem2 = new MenuItem();
                menuItem2.setLabel(menuItem.label);
                menuItem2.setEnabled(menuItem.runnable != null);
                if (menuItem.runnable != null) {
                    menuItem2.addActionListener(actionEvent -> new Thread(menuItem.runnable).start());
                }
                popupMenu.add(menuItem2);
            }
            this.tray_icon.setPopupMenu(popupMenu);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    protected void replaceIcon0(File file) {
        try {
            this.tray_icon.setImage(this.getIcon(file));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private Image getIcon(File file) throws IOException {
        Dimension dimension = SystemTray.getSystemTray().getTrayIconSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.fillRect(0, 0, n, n2);
        graphics.drawImage(ImageIO.read(file), 0, 0, n, n2, null);
        return bufferedImage;
    }
}

