/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.indicator;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;

public abstract class ApplicationIndicator<T> {
    private static final boolean PLAY_SOUND = Boolean.parseBoolean(System.getProperty("at.jku.ssw.mevss.indicator.ApplicationIndicator.sound", Boolean.TRUE.toString()));
    public final String title;
    protected final Set<T> states;
    protected final Map<T, File> state_icons;
    protected final Map<T, String> state_messages;
    protected final Map<T, File> state_audios;
    protected final List<MenuItem<T>> state_actions;
    private T state;
    private Thread icon_worker = null;

    @SafeVarargs
    public ApplicationIndicator(String string, T[] TArray, File[] fileArray, String[] stringArray, File[] fileArray2, MenuItem<T> ... menuItemArray) {
        this.title = string;
        this.states = Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(TArray)));
        HashMap<T, File> hashMap = new HashMap<T, File>();
        HashMap<T, String> hashMap2 = new HashMap<T, String>();
        HashMap<T, File> hashMap3 = new HashMap<T, File>();
        for (int i = 0; i < TArray.length; ++i) {
            hashMap.put(TArray[i], fileArray[i]);
            hashMap2.put(TArray[i], stringArray[i]);
            hashMap3.put(TArray[i], fileArray2[i]);
        }
        this.state_icons = Collections.unmodifiableMap(hashMap);
        this.state_messages = Collections.unmodifiableMap(hashMap2);
        this.state_audios = Collections.unmodifiableMap(hashMap3);
        this.state_actions = Collections.unmodifiableList(Arrays.asList(menuItemArray));
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.destroyIconWorker();
        }
        this.setVisible0(bl);
        if (bl) {
            this.initIconWorker(this.state_icons.get(this.state));
            this.startIconWorker();
        }
    }

    protected abstract void setVisible0(boolean var1);

    public boolean isVisible() {
        return this.isVisible0();
    }

    protected abstract boolean isVisible0();

    public void setState(T t) {
        this.validateState(t);
        boolean bl = this.state != t;
        this.state = t;
        if (bl) {
            File file;
            this.destroyIconWorker();
            File file2 = this.initIconWorker(this.state_icons.get(t));
            String string = this.state_messages.get(t);
            MenuItem[] menuItemArray = (MenuItem[])this.state_actions.stream().filter(menuItem -> menuItem.valid_states.contains(t)).toArray(MenuItem[]::new);
            this.setState0(t, file2, string, menuItemArray);
            this.startIconWorker();
            if (PLAY_SOUND && this.isVisible() && (file = this.state_audios.get(t)) != null) {
                ApplicationIndicator.play(file);
            }
        }
    }

    private File initIconWorker(File file) {
        this.destroyIconWorker();
        if (file.getName().endsWith(".mygif")) {
            this.icon_worker = new Thread(() -> this.runGIF(file));
            this.icon_worker.setDaemon(true);
            return new File(file.getAbsolutePath() + ".0.png");
        }
        return file;
    }

    private void startIconWorker() {
        if (this.icon_worker != null && this.isVisible()) {
            this.icon_worker.start();
        }
    }

    private void destroyIconWorker() {
        if (this.icon_worker != null) {
            this.icon_worker.interrupt();
            try {
                this.icon_worker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            assert (!this.icon_worker.isAlive());
            this.icon_worker = null;
        }
    }

    protected abstract void setState0(T var1, File var2, String var3, MenuItem<T>[] var4);

    private void runGIF(File file) {
        int n;
        int n2;
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            n2 = dataInputStream.readInt();
            n = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return;
        }
        int n3 = (int)(1.0 * (double)n2 / (double)n * 1000.0);
        n3 = Math.max(500, n3);
        block13: while (!Thread.currentThread().isInterrupted()) {
            for (int i = 0; i < n; ++i) {
                String string = file.getAbsolutePath() + "." + i + ".png";
                this.replaceIcon0(new File(string));
                try {
                    Thread.sleep(n3);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    continue block13;
                }
            }
        }
    }

    protected abstract void replaceIcon0(File var1);

    private void validateState(T t) {
        if (!this.states.contains(t)) {
            throw new IllegalArgumentException();
        }
    }

    private static void play(File file) {
        try {
            Clip clip = AudioSystem.getClip();
            clip.open(AudioSystem.getAudioInputStream(file));
            ((FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN)).setValue(-10.0f);
            clip.start();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    public static final class MenuItem<T> {
        private static int NEXT_ID = 0;
        public final int id = NEXT_ID++;
        public final String label;
        public final Runnable runnable;
        public final Set<T> valid_states;

        @SafeVarargs
        public MenuItem(T ... TArray) {
            this(null, TArray);
        }

        @SafeVarargs
        public MenuItem(String string, T ... TArray) {
            this(string, null, TArray);
        }

        @SafeVarargs
        public MenuItem(String string, Runnable runnable, T ... TArray) {
            this.label = string;
            this.runnable = runnable;
            this.valid_states = Collections.synchronizedSet(new HashSet<T>(Arrays.asList(TArray)));
        }
    }
}

