/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.indicator;

import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteCallbackable;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteMaster;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteProject;
import at.jku.ssw.mevss.indicator.Application;
import at.jku.ssw.mevss.indicator.ApplicationFactory;
import at.jku.ssw.mevss.indicator.ApplicationIndicator;
import at.jku.ssw.mevss.indicator.ApplicationIndicatorFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class Main {
    private static final int S = 1000;
    private static final int M = 60000;
    private static final int POLL_INTERVAL = 900000;
    private static final int PING_INTERVAL = 1800000;
    private static final int RECONNECT_INTERVAL = 60000;
    private static final int ERROR_DELAY = 10000;
    private static final Logger LOGGER = Logger.getLogger("cerberus.appindicator");
    private static final Color HEAVENLY_BLUE = new Color(105, 145, 250);
    private static final File OK_AUDIO = new File("ok.wav");
    private static final File ERROR_AUDIO = new File("error.wav");
    private static final Application CI_APPLICATION;
    private static final ApplicationIndicator<CIState> CI_INDICATOR;
    private static final Map<BuildID, ApplicationIndicator<BuildState>> BUILD_INDICATORS;
    private static String HOST;
    private static int PORT;
    private static String PROJECT;
    private static boolean SHOW_BUILDS;

    private static void toggleShowBuilds() {
        String user;
        if (SHOW_BUILDS && ((user = System.getProperty("user.name").toLowerCase()).contains("christina") || user.contains("rammerstorfer") || user.contains("cr"))) {
            int result = JOptionPane.showConfirmDialog(null, "Bitte blende nicht meine s\u00fc\u00dfen Icons aus! *liebschau*", "Liebe Christina", 2, 3);
            if (result == 0) {
                return;
            }
            JOptionPane.showMessageDialog(null, ";(");
        }
        LOGGER.log(Level.INFO, "toggling show build indicators ...");
        SHOW_BUILDS = !SHOW_BUILDS;
        BUILD_INDICATORS.values().forEach(i -> i.setVisible(SHOW_BUILDS));
    }

    private static File createImage(Color color, int shape, String ... image_paths) throws IOException {
        return Main.createImage(File.createTempFile(".icon", ".png", new File("./")).toString(), color, shape, image_paths);
    }

    private static File createImage(String name, Color color, int shape, String ... image_paths) throws IOException {
        return Main.createImage(100, "./", name, color, shape, 0.95, 0.65, image_paths);
    }

    private static File createImage(int dimension, String dest_path, String dest_name, Color color, int shape, double margin_factor, double image_scale, String ... image_paths) throws IOException {
        BufferedImage result = new BufferedImage(dimension, dimension, 2);
        Graphics graphics = result.getGraphics();
        graphics.setColor(color);
        int margin = (int)((double)dimension * (1.0 - margin_factor));
        switch (shape) {
            case 1: {
                graphics.fillOval(0 + margin, 0 + margin, dimension - margin * 2, dimension - margin * 2);
                break;
            }
            case 2: {
                graphics.fillRoundRect(margin, margin, dimension - margin * 2, dimension - margin * 2, dimension / 4, dimension / 4);
            }
        }
        int image_margin = (int)(1.0 * (double)dimension * (1.0 - image_scale) / 2.0);
        for (String image_path : image_paths) {
            BufferedImage image = ImageIO.read(new File(image_path));
            graphics.drawImage(image, 0 + image_margin, 0 + image_margin, dimension - image_margin * 2, dimension - image_margin * 2, null);
        }
        File file = new File(dest_path + File.separator + dest_name);
        ImageIO.write((RenderedImage)result, "png", file);
        file.deleteOnExit();
        return file;
    }

    private static File createImageGIF(File icon, double rotation_factor) throws IOException {
        return Main.createImageGIF("./", File.createTempFile(".icon", ".mygif", new File("./")).getName(), icon, rotation_factor);
    }

    private static File createImageGIF(String dest_path, String dest_name, File icon, double rotation_factor) throws IOException {
        boolean rotation_time = true;
        int frame_count = 20;
        BufferedImage image = ImageIO.read(icon);
        File result = new File(dest_path + File.separator + dest_name);
        for (int i = 0; i < 20; ++i) {
            BufferedImage frame = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
            Graphics graphics = frame.getGraphics();
            AffineTransform tx = AffineTransform.getRotateInstance(Math.toRadians(18.0 * (double)i * rotation_factor), image.getWidth() / 2, image.getHeight() / 2);
            AffineTransformOp op = new AffineTransformOp(tx, 2);
            graphics.drawImage(op.filter(image, null), 0, 0, null);
            ImageIO.write((RenderedImage)frame, "png", new File(dest_path + File.separator + dest_name + "." + i + ".png"));
        }
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(result));){
            out.writeInt(1);
            out.writeInt(20);
        }
        result.deleteOnExit();
        return result;
    }

    public static void main(String[] args) throws InterruptedException, ClassNotFoundException {
        if (args.length != 3) {
            System.err.println("Please provide url and port for the CI master, and the project!");
            System.exit(1);
        }
        HOST = args[0];
        PORT = Integer.parseInt(args[1]);
        PROJECT = args[2];
        try {
            Main.main();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "unexpected fatal error", t);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main() throws InterruptedException, ClassNotFoundException {
        CI_INDICATOR.setState(CIState.DISCONNECTED);
        CI_INDICATOR.setVisible(true);
        LOGGER.log(Level.INFO, "starting");
        while (true) {
            long delay;
            try {
                RemoteMaster master = Main.getMaster();
                RemoteProject project = master.getProject(PROJECT);
                if (project == null) {
                    throw new ConnectException("No such project");
                }
                Main.run(master, project);
                delay = 0L;
            }
            catch (ConnectException | NotBoundException e) {
                delay = 60000L;
            }
            catch (RemoteException e) {
                LOGGER.log(Level.SEVERE, "internal error", e);
                delay = 10000L;
            }
            finally {
                CI_INDICATOR.setState(CIState.DISCONNECTED);
                BUILD_INDICATORS.values().forEach(i -> i.setVisible(false));
            }
            Thread.sleep(delay);
        }
    }

    private static RemoteMaster getMaster() throws RemoteException, NotBoundException {
        Registry registry = LocateRegistry.getRegistry(HOST, PORT);
        return (RemoteMaster)registry.lookup("CI_Master");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(RemoteMaster master, final RemoteProject project) throws RemoteException, InterruptedException {
        RemoteProject.Listener listener;
        LOGGER.log(Level.INFO, "running");
        long id = master.getID();
        if (Main.canCallback(master)) {
            listener = new RemoteProject.Listener(){

                @Override
                public void buildCreated(BuildID id) {
                    Main.reset(project, HOST, PORT);
                }

                @Override
                public void buildChanged(BuildID id) {
                    Main.reset(project, HOST, PORT);
                }

                @Override
                public void buildRemoved(BuildID id) {
                    Main.reset(project, HOST, PORT);
                }
            };
            UnicastRemoteObject.exportObject((Remote)listener, 0);
            project.addListener(listener);
        } else {
            listener = null;
        }
        try {
            Main.resetCIState(project);
            while (id == master.getID()) {
                if (listener == null) {
                    Main.reset(project, HOST, PORT);
                    Thread.sleep(Math.min(900000, 1800000));
                    continue;
                }
                Thread.sleep(1800000L);
            }
        }
        finally {
            if (listener != null) {
                try {
                    project.removeListener(listener);
                }
                catch (RemoteException remoteException) {}
                UnicastRemoteObject.unexportObject(listener, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canCallback(RemoteMaster master) {
        RemoteCallbackable.RemoteCallback callback = () -> {};
        try {
            UnicastRemoteObject.exportObject((Remote)callback, 0);
            boolean bl = master.canCallback(callback);
            return bl;
        }
        catch (RemoteException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                UnicastRemoteObject.unexportObject(callback, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {}
        }
    }

    private static synchronized void reset(RemoteProject project, String host, int port) {
        try {
            for (BuildID env : (BuildID[])Stream.of(project.getEnvironments()).sorted().toArray(BuildID[]::new)) {
                Main.setBuildState(env, Main.getBuildState(project, env));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "unexpected error", e);
            BUILD_INDICATORS.values().forEach(i -> i.setVisible(false));
            CI_INDICATOR.setState(CIState.DISCONNECTED);
        }
    }

    private static BuildState getBuildState(RemoteProject project, BuildID env) throws RemoteException {
        BuildID latest = project.getLatestBuild(env);
        if (latest != null) {
            Boolean build = project.getBuildInfo(latest).getBuildResult();
            if (build == null) {
                return BuildState.UNKNOWN;
            }
            if (!build.booleanValue()) {
                return BuildState.BUILD_FAILED;
            }
        }
        for (String name : project.getFunctionalTests()) {
            BuildID latest2 = project.getLatestBuildWithActionRun(env, Capability.FUNCTIONAL_TEST, name);
            if (latest2 == null) continue;
            Boolean test = project.getBuildInfo(latest2).getTestResults().get(name);
            if (test == null) {
                return BuildState.UNKNOWN;
            }
            if (test.booleanValue()) continue;
            return BuildState.TEST_FAILED;
        }
        return BuildState.OK;
    }

    private static void setBuildState(BuildID env, BuildState state) throws IOException {
        if (env == null || state == null) {
            throw new NullPointerException();
        }
        ApplicationIndicator<BuildState> indicator = Main.getBuildIndicator(env);
        LOGGER.log(Level.INFO, "setting build indicator for " + env + " to " + (Object)((Object)state));
        indicator.setState(state);
        indicator.setVisible(SHOW_BUILDS);
    }

    private static ApplicationIndicator<BuildState> getBuildIndicator(BuildID env) throws IOException {
        if (env == null) {
            throw new NullPointerException();
        }
        ApplicationIndicator<BuildState> build_indicator = BUILD_INDICATORS.get(env);
        if (build_indicator == null) {
            LOGGER.log(Level.INFO, "creating build indicator for " + env + " ...");
            build_indicator = ApplicationIndicatorFactory.create("Build " + env, new BuildState[]{BuildState.UNKNOWN, BuildState.OK, BuildState.BUILD_FAILED, BuildState.PERFORMANCE_FAILED, BuildState.TEST_FAILED}, new File[]{Main.createImage(new Color(0, 0, 0, 0), 2, env.getOS().toLowerCase() + ".png"), Main.createImage(Color.GREEN, 2, env.getOS().toLowerCase() + ".png"), Main.createImage(Color.RED, 2, env.getOS().toLowerCase() + ".png"), Main.createImage(Color.CYAN, 2, env.getOS().toLowerCase() + ".png"), Main.createImage(Color.ORANGE, 2, env.getOS().toLowerCase() + ".png")}, new String[]{"No build of " + env.toString() + " available", "Build and tests of " + env.toString() + " successful", "Build of " + env.toString() + " failed", "Performance test of " + env.toString() + " failed", "Test of " + env.toString() + " failed"}, new File[]{null, OK_AUDIO, ERROR_AUDIO, ERROR_AUDIO, ERROR_AUDIO}, new ApplicationIndicator.MenuItem<BuildState>("Build state " + env, (T[])BuildState.values()), new ApplicationIndicator.MenuItem<BuildState>("no build available yet - unknown", (T[])new BuildState[]{BuildState.UNKNOWN}), new ApplicationIndicator.MenuItem<BuildState>("ok", (T[])new BuildState[]{BuildState.OK}), new ApplicationIndicator.MenuItem<BuildState>("test failure", (T[])new BuildState[]{BuildState.TEST_FAILED}), new ApplicationIndicator.MenuItem<BuildState>("build failure", (T[])new BuildState[]{BuildState.BUILD_FAILED}), new ApplicationIndicator.MenuItem<BuildState>(BuildState.BUILD_FAILED, BuildState.TEST_FAILED), new ApplicationIndicator.MenuItem<BuildState>("Examine ...", CI_APPLICATION != null ? () -> CI_APPLICATION.start(Main.toClientParameters()) : null, (T[])new BuildState[]{BuildState.TEST_FAILED, BuildState.BUILD_FAILED}));
            build_indicator.setState(BuildState.UNKNOWN);
            BUILD_INDICATORS.put(env, build_indicator);
        }
        return build_indicator;
    }

    private static String[] toClientParameters() {
        return new String[]{HOST, String.valueOf(PORT) + "!", PROJECT};
    }

    private static void resetCIState(RemoteProject project) {
        LOGGER.log(Level.INFO, "checking CI status ...");
        LOGGER.log(Level.INFO, "setting CI indicator to OK ...");
        CI_INDICATOR.setState(CIState.OK);
    }

    static {
        BUILD_INDICATORS = new HashMap<BuildID, ApplicationIndicator<BuildState>>();
        SHOW_BUILDS = true;
        try {
            LOGGER.log(Level.INFO, "looking up application ...");
            CI_APPLICATION = ApplicationFactory.create("Cerberus_Client");
            LOGGER.log(Level.INFO, "creating CI indicator ...");
            CI_INDICATOR = ApplicationIndicatorFactory.create("CI", new CIState[]{CIState.DISCONNECTED, CIState.OK, CIState.REPOS_DOWN, CIState.SLAVE_DOWN}, new File[]{Main.createImage(Color.WHITE, 1, new String[0]), Main.createImage(Color.GREEN, 1, new String[0]), Main.createImage(Color.ORANGE, 1, new String[0]), Main.createImage(Color.RED, 1, new String[0])}, new String[]{"Unable to establish connection", "CI is healthy", "One or more repositories are down", "One or more slaves are down"}, new File[]{ERROR_AUDIO, OK_AUDIO, ERROR_AUDIO, ERROR_AUDIO}, new ApplicationIndicator.MenuItem<CIState>("CI state", (T[])CIState.values()), new ApplicationIndicator.MenuItem<CIState>("disconnected", (T[])new CIState[]{CIState.DISCONNECTED}), new ApplicationIndicator.MenuItem<CIState>("repository(s) down", (T[])new CIState[]{CIState.REPOS_DOWN}), new ApplicationIndicator.MenuItem<CIState>("slave(s) down", (T[])new CIState[]{CIState.SLAVE_DOWN}), new ApplicationIndicator.MenuItem<CIState>("ok", (T[])new CIState[]{CIState.OK}), new ApplicationIndicator.MenuItem<CIState>(CIState.values()), new ApplicationIndicator.MenuItem<CIState>("Details ...", CI_APPLICATION != null ? () -> CI_APPLICATION.start(Main.toClientParameters()) : null, (T[])CIState.values()), new ApplicationIndicator.MenuItem<CIState>(CIState.values()), new ApplicationIndicator.MenuItem<CIState>("Toggle show builds", () -> Main.toggleShowBuilds(), (T[])CIState.values()), new ApplicationIndicator.MenuItem<CIState>(CIState.values()), new ApplicationIndicator.MenuItem<CIState>("Restart", () -> System.exit(1), (T[])CIState.values()), new ApplicationIndicator.MenuItem<CIState>("Quit", () -> System.exit(0), (T[])CIState.values()));
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError(ioe);
        }
    }

    private static enum BuildState {
        UNKNOWN,
        BUILD_FAILED,
        TEST_FAILED,
        PERFORMANCE_FAILED,
        OK;

    }

    private static enum CIState {
        DISCONNECTED,
        SLAVE_DOWN,
        REPOS_DOWN,
        OK;

    }
}

