/*
 * cst.java   Version 1.0 11/07/97 rrh, kmd, salina
 *
 * Copyright (c) 1996 IBM Corporation, Inc. All rights reserved.
 *
 * Permission is expressly granted by IBM Corporation only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 *
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Randy Heisch       IBM Corp. - Austin, TX
 *
 * SPEC development version @(#)cst.java	1.10 10/23/97
 */
package spec.benchmarks._208_cst;
import spec.harness.*;

import java.util.*;
import java.lang.*;


public class cst
   {

   private boolean standalone = true;

   static void usage()
      {
//    spec.harness.Context.out.println("Usage:\n\n   main  [-p pct] [-i iter] [-v]\n");
//    spec.harness.Context.out.println("where 0 < pct < 100 (% total run), iter=iterations, -v for verbose");
      return;
      }


  public long inst_main(String[] argv) {
      return run(argv);
  }

  public long run(String[] args) {
      int i, rc;
      int pct = 100;
      int iter = 1;
      boolean verbose = false;
      long start, stop;
	  String filename = "nasachrn.txt";
	  String filenamedict = "dict1";

      Output o = new Output();



      for (i = 0; i < args.length; i++)
         {
	 spec.harness.Context.out.println("args["+i+"]:  "+args[i]);
	 }
	 
      for (i = 0; i < args.length; i++)
         {    
         if ( args[i].equals("-p") || args[i].equals("p") )
            {
            i++;
            pct = Integer.parseInt(args[i]);
            }
         else
         if ( args[i].equals("-i") || args[i].equals("i") )
            {
            i++;
            iter = Integer.parseInt(args[i]);
            }
         else
         if ( args[i].equals("-v") || args[i].equals("v") )
	               {
			 i++;
		 	  int vx = Integer.parseInt(args[i]);
                          if (vx == 0) verbose = false;
			  else         verbose =  true;			 
		       }
         else
         if ( args[i].equals("-f") || args[i].equals("f") )
			{
			i++;
			filename = args[i];
			}
         else
         if ( args[i].equals("-d") || args[i].equals("d") )
			{
			i++;
			filenamedict = args[i];
			}
         else
            {
            spec.harness.Context.out.println("Invalid option ("+args[i]+")");
            usage();
            }
         }

      if (standalone) {
//**NS **	System.getProperties().list(spec.harness.Context.out); 
      }

      start = System.currentTimeMillis();
 
	 System.gc();

         StackTest St = new StackTest(pct*459000/100);
         St.runTest(iter, verbose);
         St = null;

	 System.gc();

         VectorTest vt = new VectorTest(pct*181000/100);
         vt.runTest(iter, verbose);
         vt = null;
	 System.gc();

         HashTableTest ht = new HashTableTest(pct*200000/100);
         ht.runTest(iter, verbose);
         ht = null;
	 System.gc();

         BitSetTest bst = new BitSetTest(pct*6500/100);
         bst.runTest(iter, verbose);
         bst = null;
	 System.gc();
  	
         StreamTokenizerTest st = new StreamTokenizerTest(filename, pct);
         st.runTest(7*iter, verbose);
         st = null;
	 System.gc();

         Jumble jt = new Jumble(filenamedict,pct);
         jt.runTest(verbose);
	 System.gc();
	 

      stop = System.currentTimeMillis();

//    spec.harness.Context.out.print("Done\n");

//    if ( verbose )
//       spec.harness.Context.out.println(" (Total RunTime: "+((stop-start)/1000.0)+" seconds)");

//    spec.harness.Context.out.println();
      
//    if (standalone) {
//	o.writeOutput();
//      }

	  return (stop-start);

      }

   }


