/*
 * StreamTokenizerTest.java   Version 1.0 11/07/97 rrh
 *
 * Copyright (c) 1996 IBM Corporation, Inc. All rights reserved.
 *
 * Permission is expressly granted by IBM Corporation only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 *
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Randy Heisch       IBM Corp. - Austin, TX
 *
 * SPEC development version @(#)StreamTokenizerTest.java	1.8 10/23/97
 */
package spec.benchmarks._208_cst;


import java.util.*;
import java.io.*;

public class StreamTokenizerTest
   {
  
   String filename;
   int num_bytes;
   byte[] buffer;
   int flen;
   Output o = new Output();


   StreamTokenizerTest(String filename, int p)
      {
      this.filename = filename;
      if ( p < 100 )
         flen = p;
      else
         flen = 100;
      }


   InputStream read_file()
      {
      InputStream is;
      int len, act = 0;


      try {
		
         spec.io.FileInputStream sif = new spec.io.FileInputStream(filename);
	 num_bytes = (int)sif.getContentLength();
	 num_bytes = num_bytes * flen/100;
//	 o.print(" Input test file size: "+num_bytes+" ");

         buffer = new byte[num_bytes];

	 int bytes_read;
	 while ( (bytes_read = sif.read(buffer, act , (num_bytes - act))) > 0){
	   act = act +  bytes_read;
	 }

	 sif.close();
        
	 if ( act != num_bytes )
            {
            o.println("ERROR reading test input file");
            return null;
            }
	
		

      }
      catch (IOException e)
	  {
	 spec.harness.Context.out.println("ERROR opening/accessing input file: "+filename);
	 //System.exit(1);
         };

      is = (InputStream) new ByteArrayInputStream(buffer);

      return is;
      }


   int runTest(int iterations, boolean verbose)
      {
      boolean OK;
      long start, stop;
      long t1 = 0, t2 = 0;
      InputStream is;
      StreamTokenizer tok = null;
      long words = 0;
      long numbers = 0;


      start = System.currentTimeMillis();

      o.println("Running StreamTokenizerTest");

//      o.print("   Initializing ... "); o.flush();

      if ( verbose )
         t1 = System.currentTimeMillis();

      if ( (is = read_file()) == null )
         return 1;

//      o.print("OK");
      if ( verbose )
         {
         t2 = System.currentTimeMillis();
         o.print(" ("+(t2-t1)/1000.0+" seconds)");
         }
//      o.println();



//      o.print("   StreamTokenizer test ... "); o.flush();

      if ( verbose )
         t1 = System.currentTimeMillis();

      while ( iterations-- > 0 )
         {
         numbers = 0;
         words = 0;

         tok = new StreamTokenizer(is);

         if ( false )
            {
            tok.commentChar(0);
            tok.ordinaryChar('/');
            tok.ordinaryChar('[');
            tok.ordinaryChar(']');
            tok.slashSlashComments(false);
            tok.slashStarComments(false);
            }


         OK = true;
         while ( OK )
            {
            try {
                tok.nextToken();
                }
            catch ( IOException e ) {} ;

            switch(tok.ttype)
               {
               case StreamTokenizer.TT_EOF:
                  //o.println("token=TT_EOF");
                  OK = false;
               break;

               case StreamTokenizer.TT_NUMBER:
                  //o.println("token=TT_NUMBER: "+tok.nval);
                  numbers++;
               break;

               case StreamTokenizer.TT_WORD:
                  //o.println("token=TT_WORD:   "+tok.sval);
                  words++;
               break;

               case StreamTokenizer.TT_EOL:
                  //o.println("token=TT_EOL");
                  //numlines++;
               break;

               default:
                  //o.println("token="+(char)t+": "+tok.sval);
               break;
               }

            }

         try { is.reset(); } catch ( IOException e ) {};
         }

      try { is.close(); } catch ( IOException e ) {};

      buffer = null;

//      o.print("   OK");
      if ( verbose )
         {
         t2 = System.currentTimeMillis();
         o.print(" ("+(t2-t1)/1000.0+" seconds)");
         }
//      o.println();

//      o.println("        total lines parsed:   "+tok.lineno());
//      o.println("        total words parsed:   "+words);
//      o.println("        total numbers parsed: "+numbers);
//      o.println("        total bytes:          "+num_bytes);

      stop = System.currentTimeMillis();

      if ( verbose )
         o.println("Done in "+(stop-start)/1000.0+"secs");

      o.println("Verified");
    
      return 0;
      }

   }

