/*
 * Jumble.java   Version 1.0 11/07/97 rrh, Kaivalya, Salina
 *
 * Copyright (c) 1996 IBM Corporation, Inc. All rights reserved.
 *
 * Permission is expressly granted by IBM Corporation only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 *
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Randy Heisch       IBM Corp. - Austin, TX
 *
 * SPEC development version @(#)Jumble.java	1.6 10/23/97
 */
package spec.benchmarks._208_cst;



import java.util.*;
import java.lang.*;
import java.io.*;


//
// Builds a hashtable with each dictionary word, character sorted, as keys.
// hashtable objects contain a vector of all dictionary words with that same
// character sorted key.  A dictionary vector of character sorted words is
// also built which is used to verify all dictionary words.
//
// Randy Heisch  02/09/97
//


public class Jumble
   {
   
   int num_bytes;
   byte[] buffer;
   int flen = 100;
   String strings[] = null;
   Output o = new Output();
   String filename = "";

   Jumble(String dictfile,int p)
   {
	flen = p;
	filename = dictfile;	  
   }

   Jumble(String [] s)
      {
      strings = s;
      }

  InputStream read_file()
      {
      InputStream is;
      int len, act=0;
      String fn = filename;


      try {
		
	spec.io.FileInputStream sif = new spec.io.FileInputStream(fn);
	num_bytes = flen * (int)sif.getContentLength()/100;
//	o.println("   Dictionary file size: "+num_bytes);
	buffer = new byte[num_bytes];
//	o.print("   Reading dictionary ..."); o.flush();

	int bytes_read;
	while ( (bytes_read = sif.read(buffer, act , (num_bytes - act))) > 0){
	  act = act +  bytes_read;
	}
	
	sif.close();

	if ( act != num_bytes ){
	    o.println("ERROR reading test input file");
	    return null;
	}

	sif.close();
//	o.println(" OK");
		

    }
    catch (IOException e){
       o.println("ERROR opening dictionary file ("+fn+")");
      //System.exit(1);
    };

      is = (InputStream) new ByteArrayInputStream(buffer,0,act);

      return is;
 }


String char_sort(String s)
   {
   int i, n;
   String rs;
   byte t;

   n = s.length();

   byte[] b = new byte[n];

   s.getBytes(0, n, b, 0);

   for ( ; n > 0; n--)
      for (i = 0; i < (n-1); i++)
         if ( b[i] > b[i+1] )
            {
            t = b[i+1];
            b[i+1] = b[i];
            b[i] = t;
            }

   rs = new String(b, 0);

   return rs;
   }



   void runTest(boolean verbose)
      {
      int i, n, max;
      boolean OK;
      double start, stop;
      double t1 = 0.0, t2 = 0.0;
      InputStream is;
      StreamTokenizer tok = null;
      String s;

      Hashtable ht = new Hashtable(40000);
      Vector vector;
      Vector dict = new Vector(90000);


      start = System.currentTimeMillis();

      o.println("Running Jumble (hashtable/vector) test ... ");

      if ( (is = read_file()) == null )
         return;

      tok = new StreamTokenizer(is);
      tok.lowerCaseMode(true);

//    o.print("   Building dictionary hashtable ...");
//    o.flush();
      if ( verbose )
         t1 = System.currentTimeMillis();
      OK = true;
      while ( OK )
         {
         try { tok.nextToken(); } catch ( IOException e ) {} ;

         switch(tok.ttype)
            {
            case StreamTokenizer.TT_EOF: OK = false; break;

            case StreamTokenizer.TT_WORD:

               s = char_sort(tok.sval);

               dict.addElement(s);

               if ( ht.get(s) == null )
                  {
                  vector = new Vector();

                  ht.put(s, vector);
                  }
               else
                  vector = (Vector)ht.get(s);

               //vector.addElement(new String(tok.sval));
               vector.addElement(tok.sval);

            break;
            }

         }

//    o.print("OK");
      if ( verbose )
         {
         t2 = System.currentTimeMillis();
         o.print(" ("+(t2-t1)/1000.0+" seconds)");
         }
//    o.println();

      if ( strings != null )
         {
         for (i = 0; i < strings.length; i++)
            {
            s = char_sort(strings[i]);

            if ( (vector = (Vector)ht.get(s)) == null )
               {
               o.println("ERROR: "+s+" not found");
               //System.exit(1);
               }

            o.println(strings[i]);

            for (Enumeration v = vector.elements(); v.hasMoreElements();)
               {
               s = (String)v.nextElement();

               o.println("   "+s);
               }
            }

         //System.exit(0);
         }


//    o.print("   Looking up all dictionary words ...");
//    o.flush();
      if ( verbose )
         t1 = System.currentTimeMillis();

      for (Enumeration e = dict.elements(); e.hasMoreElements();)
         {
         s = (String)e.nextElement();

         if ( (vector = (Vector)ht.get(s)) == null )
            {
            o.println("ERROR: "+s+" not found");
            //System.exit(1);
            }

         //o.println(s);

         for (Enumeration v = vector.elements(); v.hasMoreElements();)
            {
            s = (String)v.nextElement();

            //o.println("   "+s);
            }

         }

//    o.print("OK");
      if ( verbose )
         {
         t2 = System.currentTimeMillis();
         o.print(" ("+(t2-t1)/1000.0+" seconds)");
         }
//    o.println();

      stop = System.currentTimeMillis();

      if ( verbose ) {
         o.println("Done in "+(stop-start)/1000.0+" seconds");
      }
    
      o.println("Verified");

   }
}


