package spec.benchmarks._225_shock;
//-----------------------begin header-------------------------------------
//------------------------------------------------------------------------
// ComputeTracker - shared data object for tracking progress of BoundaryThreads
//
// (c) 1997.
//
// Adopted from TSUNAMI (Transient Shockwave Upwind Numerical Analysis Method
// for ICF) code courtesy of James Liu, and UC Berkeley Department of Nuclear
// Engineering.
//
// Algorithms based on CFD methods published by Colella, et al., Dept.
// of Mechanical Engineering, UC Berkeley.
//
// Original Research Performed by UCB Dept. of Nuclear Engineering are under 
// the auspices of the US Dept. of Energy for the Lawrence Livermore National
// Laboratory under contract W-7405-ENG-48.
//------------------------------------------------------------------------
// Permission to use, modify and distribute this source is hereby granted for
// educational and benchmarking purposes provided that this header is included
// in subsequent modifications.
//
// Neither the author(s) nor the University of California and LLNL/DOE make
// any claims of computational accuracy or fitfullness for engineering uses
// or take any responsibility for any damages to users incurred directly or
// indirectly by the usage of this source.  Users accept all the consequences.
//------------------------------------------------------------------------
//-------------------------end header-------------------------------------

public class ComputeTracker {

    private int cellsRemaining;
    private int ncell;

    public ComputeTracker(int ncell) {
	this.ncell = ncell;
	cellsRemaining = ncell;
    }


    public synchronized void completedCell(int cell) {
	try {
	    cellsRemaining--;
	} catch (Exception e) {
	}
	notify();
    }

    public synchronized void waitForCompletion() {
	try {
	    while(cellsRemaining > 0) {;
		wait();
	    }
	    cellsRemaining = ncell;
	} catch (Exception e) {
	}
	notify();
    }
}
