/*
 * @(#)SolarisSparc.java	1.4 02/05/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 * SolarisSparc
 * return configuration properties appropriate for Solaris/SPARC systems
 * determined by running native commands like prtconf(1M).
 */
package spec.reporter.vendor;

import java.io.*;
import java.util.Properties;

public class SolarisSparc implements VendorConfig{

/*
 * table of URL's of some Solaris/SPARC vendors
 * This may not be complete, but could help as a first guess if these
 * names turn up in hardware vendor strings 
 */
private static String[] vendorMap = {
    "Amdahl",		"http://www.amdahl.com/",
    "Antares",		"http://www.antares.com/",
    "Auspex",		"http://www.auspex.com/",
    "Force",		"http://www.forcecomputers.com/",
    "Fujitsu",		"http://www.fujitsu.com/",
    "HAL",		"http://www.hal.com/",
    "Matsushita",	"http://www.mei.co.jp/",
    "Opus",		"http://www.opus.com/",
    "RDI",		"http://www.rdi.com/",
    "Ross",		"http://www.ross.com/",
    "Sun",		"http://www.sun.com/",
    "Tadpole",		"http://www.tadpole.com/",
    "Themis",		"http://www.themis.com/",
    "Toshiba",		"http://www.toshiba.com/",
};

/*
 * labels found in the prtconf output
 */
private static String[] labels = {
    "banner-name:",
    "clock-frequency:",
    "dcache-associativity:",
    "dcache-line-size:",
    "dcache-nlines:",
    "dcache-size:",
    "ecache-associativity:",
    "ecache-line-size:",
    "ecache-nlines:",
    "ecache-size:",
    "icache-associativity:",
    "icache-line-size:",
    "icache-nlines:",
    "icache-size:",
    "Memory size:",
    "name:",
    "System Configuration:"
};
private Properties values = new Properties();

public Properties getProperties (Properties props, String cOrS,
    PrintStream err)
{
    String cs = "spec." + cOrS + ".";
    props.put (cs + "hw.fileSystem","UFS");
    String deviceTypeCpu = "device_type:  'cpu'";
    int ncpu = 0;
    for (int i=0; i<labels.length; i++)
        values.put(labels[i],"n/a");
    Process process;
    InputStream co;
    DataInputStream procOutput;
    Runtime r = java.lang.Runtime.getRuntime();
    try{
        process = r.exec ("/usr/sbin/prtconf -pv");
        procOutput = new DataInputStream(
            new BufferedInputStream(process.getInputStream()));
        String s;
        while((s = procOutput.readLine()) != null){
            s = s.trim();
            String lbl = s.substring(0,s.indexOf(':')+1).trim();
            String val = s.substring(s.indexOf(':')+1).trim();
            if (s.equals(deviceTypeCpu)){
                ncpu++;
            }else if (values.get(lbl) != null){
                values.put(lbl,val);
            }
        }
        int code = process.waitFor();
        props.put(cs + "hw.ncpu",Integer.toString(ncpu));
        int mhz = hexval("clock-frequency:") / 1000000;
        props.put(cs + "hw.MHz", Integer.toString(mhz));
        props.put(cs + "hw.processor",values.get("name:"));
        String vendorName = (String) values.get("System Configuration:");
        props.put(cs + "hw.vendor", vendorName);
	props.put (cs + "hw.vendor.url", getURL(vendorName));
        s = (String) values.get("Memory size:");
        props.put(cs + "hw.memory",s.substring(0,s.indexOf(' ')));
        props.put(cs + "hw.model",values.get("banner-name:"));
        int is =  hexval("icache-size:");
        int ils = hexval("icache-line-size:");
        int inl = hexval("icache-nlines:");
        int ia =  hexval("icache-associativity:");
        if (is == 0) is = inl * ils * ia;
        int ds =  hexval("dcache-size:");
        int dls = hexval("dcache-line-size:");
        int dnl = hexval("dcache-nlines:");
        int da =  hexval("dcache-associativity:");
        if (ds == 0) ds = dnl * dls * da;
        int es =  hexval("ecache-size:");
        int enl = hexval("ecache-nlines:");
        int els = hexval("ecache-line-size:");
        int ea =  hexval("ecache-associativity:");
        if (es == 0) es = enl * els * ea;
        is /= 1024;
        ds /= 1024;
        es /= 1024;
        props.put(cs + "hw.primaryCache", is + "KBI + " + ds + "KBD");
        props.put(cs + "hw.secondaryCache", es + "KB(I+D)");
    }catch (Exception e){
        err.println("Error running prtconf: " + e);
	return props;
    }
    /*
     * uname
     */
    try{
        process = r.exec ("/bin/uname -rv");
        procOutput = new DataInputStream(
            new BufferedInputStream(process.getInputStream()));
        String rv = procOutput.readLine();
	if (rv == null)
	    rv = "VERSION REQUIRED";
        props.put(cs + "sw.OS","Solaris " + rv);
    }catch (Exception e){
        err.println("Error running uname: " + e);
        return props;
    }
    /*
     * hostid
     */
    try{
        process = r.exec ("/bin/hostid");
        procOutput = new DataInputStream(
            new BufferedInputStream(process.getInputStream()));
        String hid = procOutput.readLine();
	if (hid != null)
            props.put("hostid",hid);
    }catch (Exception e){
        err.println("Error running hostid: " + e);
    }
    /*
     * /etc/hosts
     */
    try{
        DataInputStream hosts = new DataInputStream(
	    new BufferedInputStream(
	    new FileInputStream ("/etc/hosts")));
	String line;
	while ((line = hosts.readLine()) != null){
	    if (line.indexOf ("loghost") > 0){
		int i = line.indexOf ('\t');
		if (i > 0)
                    props.put ("hostIP",line.substring (0,i));
		break;
	    }
	}
    }catch (Exception e){
        err.println("Error reading /etc/hosts: " + e);
    }
    return props;
}

private String getURL (String name){
    for (int i=0; i < vendorMap.length; i += 2)
	if (name.indexOf (vendorMap[i]) >= 0)
	    return vendorMap[i+1];
    return "REQUIRED";
}

private int hexval(String name){
    try{
	int h = Integer.parseInt((String) values.get(name),16);
   	return h;
    }catch (NumberFormatException e){
    	return 0;
    }
}

}
