/*
 * @(#)Config.java	1.3 02/05/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 * Print configuration properties determined by vendor
 * specific native methods.
 */
package spec.reporter.vendor;

import java.io.*;
import java.util.Enumeration;
import java.util.Properties;

public class Config{

private static String clientServer = "client";
private static String port = "80";
private static String server = "localhost";
private static String specDir = ".";
private static String vendor = null;

public static void main (String[] args){
    for (int i=0; i < args.length; i += 2){
	if (args[i].equals ("-v")){
	    vendor = "spec.reporter.vendor." + args[i+1];
	}else if (args[i].equals ("-s")){
	    server = args[i+1];
	    clientServer = "server";
	}else if (args[i].equals ("-p")){
	    port = args[i+1];
	    clientServer = "server";
	}else if (args[i].equals ("-S")){
	    specDir = args[i+1];
	}else{
	    usage();
	    return;
	}
    }
    Properties props = System.getProperties();
    if (clientServer.equals ("server")){
	WhichServer w = new WhichServer (server, port);
	props.put ("spec.server.sw.webServer", w.getServer());
    }
    if (vendor != null){
	try{
            Object v = (Class.forName (vendor)).newInstance();
            if (v instanceof VendorConfig){
                VendorConfig vc = (VendorConfig) v;
                props = vc.getProperties (props, clientServer, System.err);
            }else{
                System.out.println ("Error: " + vendor +
                    " does not implement the VendorConfig interface");
            }
	}catch (Exception e){
            System.out.println ("Error: " + e);
	}
    }
    String templateFile = specDir + "/spec/reporter/vendor/template/" +
	clientServer;
    try{
	DataInputStream in = new DataInputStream(
	    new BufferedInputStream(
	    new FileInputStream (templateFile)));
	String line;
	while ((line = in.readLine()) != null){
	    if (! line.startsWith ("#")){
		int ieq = line.indexOf ('=');
		if (ieq < 0){
		    System.out.println (line);
		    continue;
		}
		String lhs = line.substring (0,ieq);
		String rhs = line.substring (ieq+1);
		if (rhs == null || rhs.equals(""))
		    rhs = lhs;
		else if (rhs.equals ("REQUIRED")){
		    System.out.println (line);
		    continue;
		}
		String value = (String) props.get (rhs);
		props.remove (rhs);
		if (value == null)
		    value = "REQUIRED";
		System.out.println (lhs + "=" + value);
	    }else{
		System.out.println (line);
	    }
	}
	System.out.println ("# Information not required by SPEC\n" +
	    "# This is intended for test submitter's own documentation\n" +
	    "# and may be retained or removed from results submissions");
	props.remove ("line.separator");	// not this one
	for (Enumeration enum = props.keys(); enum.hasMoreElements(); ){
	    String key = (String) enum.nextElement();
	    String value = (String) props.get (key);
	    System.out.println ("spec.other." + key + "=" + value);
	}
    }catch (FileNotFoundException e){
        System.out.println ("File not found: " + templateFile + "\n" +
	    "Check your current directory or the -S option");
    }catch (IOException e){
	System.err.println ("Error " + e);
    }
}

private static void usage(){
    System.err.println ("Usage: " +
	"java spec.reporter.vendor.Config " +
	"[-v vendor] [-s server] [-p port] [-S SPECdir]\n" +
	"Create client & server property files to document a configuration\n" +
	"vendor - Specify OS & h/w, e.g. SolarisSparc\n" +
	"server - Name of server where benchmarks are installed.\n" +
	"         Default localhost\n" +
	"         If specified, creates server file instead of client file\n" +
	"port -   Server's http port number. Default 80\n" +
	"         If specified, creates server file instead of client file\n" +
	"SPECdir - Directory where SPEC software is installed, if not the\n" +
	"         current directory."
    );
}

}//end class
