/*
 * @(#)Table.java	1.3 97/08/18
 * Copyright (c) 1997 Sun Microsystems, Inc. All rights reserved
 */

package spec.reporter;

import java.io.*;
import java.util.Properties;
import java.util.Vector;
import spec.reporter.SpecPropsBranch13;

public class Table{

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////

private static String tablePrefix =
    "<TABLE WIDTH=\"100%\" BORDER=1 CELLSPACING=2 CELLPADDING=0>" +
    "<TR><TH COLSPAN=2>\n";

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////
String heading;
SpecPropsBranch13 sp;
Vector properties;

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////
Table(String h, DataInputStream in, SpecPropsBranch13 sp){
    heading = h;
    this.sp = sp;
    properties = new Vector();
    String line;
    try{
        while ((line = in.readLine()) != null){
            if (line.equals("")) break;
            properties.addElement(line);
        }
    }catch (IOException e){}
}

///////////////////////////////////////
//class method declarations
///////////////////////////////////////

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

public String toString(){
    StringBuffer buf = new StringBuffer(tablePrefix);
    buf.append(heading);
    buf.append("</TH></TR>\n");
    for (int i=0; i<properties.size(); i++){
        String name = (String) properties.elementAt(i);
	String label = sp.getTitle(name);
	if (label == null)
	    label = name + "=null";
	String val = sp.get(name);
	if (val == null || val.equals("")){
	    val = "missing"; // "&nbsp;";
	}else if (val.startsWith("http://")){
	    val = "<a href=\"" + val + "\">" + val + "</a>";
	}
	buf.append("<TR><TD><B>");
	buf.append(label);
	buf.append("</B></TD>\n<TD>");
	buf.append(val);
	buf.append("</TD></TR>\n");
    }
    buf.append("</TABLE>\n");
    return buf.toString();
}

}
