/*
 * @(#)SpecPropsBranch13.java	1.4 97/08/26
 *
 * This is a branch off of
 * @(#)SpecProps.java	1.3 97/08/05
 * for the purposes of the report generator program. It may be merged
 * back into the main line, but not yet because the report program is
 * of lower priority than the benchmark harness. To minimize final
 * integration changes, we'll leave this separate for now
 *
 * More likely we just need to factor out the common subset of
 * functions between the harness and reporter, and keep both simple.
 * Things like the priorities of different property sources is 
 * different for each.
 * -walter
 */

package spec.reporter;

import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import spec.harness.OrderedProperties;
import spec.harness.Dialog1;
import spec.harness.Dialog2;

public class SpecPropsBranch13 extends Frame {

///////////////////////////////////////
//TEMPORARY HACKS
///////////////////////////////////////
private final static int maxRows = 16;

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////
private boolean		    allowEdits;
private Dialog1		    dialog1;
private Dialog2		    dialog2;
private boolean		    initialFilesRead = false;
private Properties	    props;
private String		    specDir;
private String		    specFile;
private Properties	    specProps;
private OrderedProperties   title;
private String		    titleFile;

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////

/**
Creates a new SPEC properties object, initialized with properties read from
a file or URL "props/spec". The titles of those properties are given in "props/title".
Those files are specified relative to a base directory which is typically the
SPECjava installation directory. The user is given an opportunity to override
the default location of those files through a dialog box.
@param specDir base SPEC directory / URL prefix
*/
public SpecPropsBranch13 (String specDir){
    this (specDir, getPropUrl(specDir + "props/spec"), "props/title", true);
}

/**
Creates a new SPEC properties object, initialized with properties and titles
read from files as above.
@param specDir base directory / URL prefix
@param props Inital properties, typically from "props/spec" file
@param titleFile Default name of file with property titles
@param allowEdits Show dialog boxes for editing reporting fields?
*/
public SpecPropsBranch13 (String specDir, Properties props, String titleFile,
    boolean allowEdits)
{
    this.specDir = specDir;
    this.props = props;
    this.titleFile = titleFile;
    this.allowEdits = allowEdits;
    title = getOrderedProperties(specDir + titleFile);
    try{
	String osName = System.getProperty("os.name");
	String osArch = System.getProperty("os.arch");
	String platform = "generic";
	if (osName != null && osArch != null)
	    platform = (osName + "." + osArch).toLowerCase();
	    
	StringBuffer sb = new StringBuffer();
	for( int i = 0 ; i < platform.length() ; i++ ) {
	    char ch = platform.charAt( i );
	    if( ch != ' ' ) {
		sb.append( ch );
	    }
	}
	platform = sb.toString();

	props.put("spec.initial.platform","props/" + platform);
	props.put("java.version",System.getProperty("java.version"));
	props.put("java.vendor.url",System.getProperty("java.vendor.url"));
	props.put("java.vendor",System.getProperty("java.vendor"));
	/* Netscape security manager doesn't allow us to read this non-critical property
	   Just omit it for now unless we find a way to catch security exceptions
	props.put("user.name",System.getProperty("user.name"));
	*/
    }catch (SecurityException e){
	 // disallowed system properties just aren't set
    }
    if (allowEdits) selectFiles();
}

///////////////////////////////////////
//class method declarations
///////////////////////////////////////

private static Properties getProp (InputStream in) throws IOException {
    Properties p = new Properties();
    p.load(in);
    return p;
}

public static Properties getPropFile (String name){
    Properties p = null;
    try{
	p = getProp (new BufferedInputStream(new FileInputStream (name)));
    }catch (Exception e){
        spec.harness.Context.out.println("Error loading properties: " + e);
    }
    return p;
}

public static Properties getPropMail (String name){
    Properties p = new Properties();
    try{
	DataInputStream in = new DataInputStream(
	    new BufferedInputStream(new FileInputStream (name)));
	String line;
	while ((line = in.readLine()) != null){
	    if (line.startsWith("#")) continue;
	    int i = line.indexOf('=');
	    if (i < 0) continue;
	    String key = line.substring (0,i);
	    String value = line.substring (i+1);
	    p.put (key,value);
	}
    }catch (Exception e){
        spec.harness.Context.out.println("Error loading properties: " + e);
    }
    return p;
}

public static Properties getPropUrl (String urlString){
    Properties p = new Properties();
    loadUrl (p, urlString);
    return p;
}

private static void loadUrl (Properties p, String urlString){
    try{
    	URL url = new URL(urlString);
        p.load (new BufferedInputStream( url.openStream() ));
    }catch (MalformedURLException e){
        spec.harness.Context.out.println("Malformed URL for properties: " + urlString);
    }catch (Exception e){
        spec.harness.Context.out.println("Error loading properties: " + e);
    }
}

public static void merge(Properties primary, Properties secondary){
    if (secondary == null)
	return;
    if (primary == null){
	primary = secondary;
	return;
    }
    for (Enumeration e = secondary.propertyNames(); e.hasMoreElements();){
        String name = (String) e.nextElement();
        String value = secondary.getProperty(name,"");
	if (primary.getProperty(name) == null)
	    primary.put(name,value);
    }
}

/*
private static void merge (String primary, Properties secondary){
    merge (getPropUrl (primary), secondary);
}
*/

/**
@deprecated renamed
@see getPropUrl
*/
public static Properties getProperties (String urlString){
    return getPropUrl (urlString);
}

private static OrderedProperties getOrderedProperties (String urlString){
    OrderedProperties p = new OrderedProperties();
    loadUrl(p, urlString);
    return p;
}

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

/**
 Get the property value associated with the key.
 @param key key value
 @return property value (may be null if property does not exist)
 Note that both key and value are Strings, not general Objects
 @see java.util.Hashtable#get
 */
public String get (String key){
    if (props == null)
	return null;
    else
	return (String) props.get(key);
}

/**
 Get the property value associated with the key,
 or if there is none then return the supplied default value
 @param key key value
 @param def default value
 @return property value or def if property does not exist
 */
public String get (String key, String def){
    if (props == null)
	return null;
    String s = (String) props.get(key);
    if (s == null)
	return def;
    else
	return s;
}

/*
return an array of strings representing keys for user editable properties
*/

private String[] getEditable(){
    Vector names = new Vector(50);
    for (int i=0; i<title.size(); i++){
	String key = (String) title.keyAt(i);
	if (! (key.startsWith("spec.initial.") || key.endsWith(".ro")))
            names.addElement(key);
    }
    String[] editable = new String[names.size()];
    for (int i=0; i<editable.length; i++)
        editable[i] = (String) names.elementAt(i);
    return editable;
}

public final Enumeration keys(){
    return props.keys();
}

/**
 Get the title property value associated with the key.
 @param key key value
 @return property value (may be null if property does not exist)
 Note that both key and value are Strings, not general Objects
 @see java.util.Hashtable#get
 */
public String getTitle (String key){
    return (String) title.get(key);
}

public boolean isSetup(){
    if (dialog2 == null)
	return false;
    else
	return dialog2.statusOK;
}

public void list (PrintStream out){
    props.list (out);
}

public boolean parametersChosen(){
    return dialog1.statusOK;
}


public void put (String key, String value){
    props.put (key, value);
}

public void save (PrintStream out, String header){
    props.save (out, header);
}

private void selectFiles(){
/* This method will never be used for spec.reporter
 * so comment it out in this branch version
    if (dialog1 == null){
	String message = (String) props.get("spec.initial.message");
        String[] editList = {
	    "spec.initial.platform", "spec.initial.clientFile",
	    "spec.initial.serverFile"
        };
        dialog1 = new Dialog1 ("select parameter files", specDir,
	    message, title, props, editList, 60);
    }
    dialog1.show();
 */
}

public void setup(){
    if (! initialFilesRead){
	Properties platform = getPropUrl(specDir + 
	    get("spec.initial.platform","props/generic"));
	merge (platform, props);    // platform overrides initial
	Properties client = getPropUrl(specDir + get("spec.initial.clientFile"));
	merge (client, platform);   // client-specific overrides platform
	Properties server = getPropUrl(specDir + get("spec.initial.serverFile"));
	merge (client, server);	    // should not conflict, but if so, client wins
	props = client;		    // net result of combining all properties
	initialFilesRead = true;
    }
/* This code will never be used for spec.reporter
 * so comment it out in this branch version
    if (allowEdits){
	if (dialog2 == null)
	    dialog2 = new Dialog2 ("edit reporting fields",
		title, props, getEditable(), 30, maxRows);
	dialog2.show();
    }
 */
}

public String toString(){
    StringBuffer buf = new StringBuffer();
    for (Enumeration e = props.keys(); e.hasMoreElements();){
        String name = (String) e.nextElement();
        String value = (String) props.get(name);
	if (value == null) value = "";
        buf.append (name + "=" + value + "\n");
    }
    return buf.toString();
}

// End class SpecProps
}

