/*
 * @(#)Run.java	1.4 97/10/31
 * Copyright (c) 1997 Sun Microsystems, Inc. All rights reserved
 */

package spec.reporter;

import java.util.Properties;
import spec.reporter.SpecPropsBranch13;
import spec.reporter.Result;

public class Run{

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////
private final static double MB = 1024 * 1024;

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////
public double			freeMemoryEnd;
public double			freeMemoryStart;
private SpecPropsBranch13	props;
public Result			result;
public double			time;
public double			totalMemoryEnd;
public double			totalMemoryStart;

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////
public Run (SpecPropsBranch13 props, int runNumber, double time, Result result){
    this.props = props;
    this.time = time;
    this.result = result;
    String prefix = "spec.results." + result.name + ".run" + runNumber;
    String s = props.get (prefix + ".valid");
    if (s == null || ! s.equals("true")){
	result.valid = false;
	result.invalidReason.append (result.name + " run " + runNumber +
	    " was not valid\n");
    }
    s = props.get (prefix + ".speed");
    if (s == null || ! s.equals("100")){
	result.valid = false;
	result.invalidReason.append (result.name + " run " + runNumber +
	    " used problem size " + s + " instead of 100\n");
    }
    s = props.get (prefix + ".stats.cache");
    if (s == null || ! s.equals("true")){
	result.valid = false;
	result.invalidReason.append (result.name + " run " + runNumber +
	    " did not have input cache enabled\n");
    }
    freeMemoryStart = getMB (prefix + ".stats.FreeMemoryStart");
    totalMemoryStart = getMB (prefix + ".stats.TotalMemoryStart");
    freeMemoryEnd = getMB (prefix + ".stats.FreeMemoryEnd");
    totalMemoryEnd = getMB (prefix + ".stats.TotalMemoryEnd");
}

///////////////////////////////////////
//class method declarations
///////////////////////////////////////

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

private double getMB (String name){
    String s = props.get (name);
    if (s == null) return -1;
    try{
	Double number = new Double(s);
	return number.doubleValue() / MB;
    }catch (NumberFormatException e){
	return -1;
    }
}

public double ratio(){
    double ref = result.referenceTime;
    if (time <= 0)
	return 0;
    else
	return ref / time;
}

}
