/*
 * @(#)Report.java	1.7 97/10/31
 * Copyright (c) 1997 Sun Microsystems, Inc. All rights reserved
 */
 
package spec.reporter;

import java.io.*;
import java.util.Enumeration;
import java.util.Properties;
import spec.reporter.SpecPropsBranch13;

public class Report{

/*
Sketch of a reporting page. Descriptive text in quotes. Variable names unquoted

- - - - - - - -  - - - - - - - -  - - - - - - - -  - - - - - - - -  - - - - - - - - 
pageHeader
 "logo" "suite name"                    "composite result"
 logo       name                        metric
 "hardware vendor and model"
 hardware
 "software vendor and version"
 software
 - - - - - - - -  - - - - - - - -  - - - - - - - -  - - - - - - - -  - - - - - - - - 
    "table and/or graph of results"
    graphTable
 - - - - - - - -  - - - - - - - -  - - - - - - - -  - - - - - - - -  - - - - - - - - 
    "configuration documentation"
    results (properties listed according to specification in props/report)
 - - - - - - - -  - - - - - - - -  - - - - - - - -  - - - - - - - -  - - - - - - - - 

*/

 ///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////

private static String logo =
    "<IMG SRC=\"images/spec-sm.gif\" ALT=\"[SPEC logo]\" ALIGN=MIDDLE>";

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////
String base;
String graphTable, hardware, metric, name, software;
String issue;
SpecPropsBranch13 props;
Properties results;
Metrics metrics;
boolean useJavaGraph;
String codeBase;

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////

public Report(String graphTable, String hardware, String codeBase,
    String metric, String name, String resultFile, String spec, 
    String software, String titles)
{
    this.codeBase = codeBase;
    useJavaGraph = codeBase != null;
    base = "file://" + 
        (new File("")).getAbsolutePath().replace('\\','/');
    Properties specprops =  SpecPropsBranch13.getPropUrl(
	base + option(spec,"props/spec"));
    issue = (String) specprops.get("spec.report.newsletter.ro");
    String raw = option(resultFile, (String) specprops.get("spec.report.rawFile"));
    Properties results = SpecPropsBranch13.getPropMail(raw);
    PropUtils.merge (results, specprops);
    props = new SpecPropsBranch13 (base, results, option(titles,"props/title"),false);
//  props.setup();
    metrics = new Metrics (props);
    if (graphTable == null)
	graphTable = metrics.tableAndGraph (useJavaGraph, codeBase);
    else
	graphTable = readFile (graphTable);
    this.graphTable = graphTable;
    this.name = option (name, props.get("spec.report.suiteName.ro"));
    this.results = loadResults(
        option (resultFile, props.get("spec.report.rawFile")));
    this.hardware = option (hardware,
        results.get("spec.client.hw.vendor") + " " +
        results.get("spec.client.hw.model"));
    if (metric == null)
	metric = metrics.composite();
    this.metric = metric;
    this.software = option (software,
        results.get("spec.client.sw.vendor") + " " +
        results.get("spec.client.sw.JVM"));
}

///////////////////////////////////////
//class method declarations
///////////////////////////////////////

private final static String option (String primary, String secondary){
    if (primary != null)
        return primary;
    else
        return secondary;
}

private static String readFile (String name){
    byte[] buf = new byte[512];
    StringBuffer sb = new StringBuffer();
    int n;
    try{
	BufferedInputStream in = new BufferedInputStream(
	    new FileInputStream (name));
	while ((n = in.read(buf, 0, buf.length)) > 0)
	    sb.append (new String (buf, 0, 0, n));
    }catch (Exception e){
	spec.harness.Context.out.println("Error: " + e);
    }
    return sb.toString();
}

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

private void listProperties (PrintStream out){
    out.println ("<!-- ");
    props.save(out,"Raw Results");
    out.println ("-->");
}
 
private Properties loadResults(String rawFile){
    Properties p = new Properties();
    try{
        p.load (new BufferedInputStream(
                new FileInputStream(rawFile)));
    }catch (Exception e){
        spec.harness.Context.out.println("Error: " + e);
        e.printStackTrace();
    }
    return p;
}

public void print (String outFile){
    outFile = option (outFile, props.get("spec.report.out"));
    String template = option (props.get("spec.report.in.ro"),"props/report");
    try{
        PrintStream out = new PrintStream(
            new BufferedOutputStream(
            new FileOutputStream (outFile)));
        out.print(
            "<HTML><HEAD><META NAME=\"GENERATOR\" CONTENT=\"" +
            "SPEC Java Reporter\">\n" +
            "<TITLE> SPEC" + name + "</TITLE>\n" +
	    "</HEAD><BODY ");
	if (metrics.valid)
	    out.print (props.get("spec.report.bodyAttributes.ro",""));
	else
	    out.print ("BACKGROUND=\"images/invalid.gif\"");
	out.print(
	    ">\n" +
            "<TABLE WIDTH=100%>\n" +
	    "<TR><TD>");
	if (issue != null && ! issue.equals(""))
	    out.print(logo);
	else
	    out.print ("<FONT SIZE=+3>SPEC</FONT>");
	out.print(
            "<FONT SIZE=+3>" + name + "</FONT></TD>\n" +
	    "<TD ALIGN=RIGHT><FONT SIZE=+1>" +
	    "    <B>" + metric + "</B></FONT></TD></TR>\n" +
            "<TR><TD COLSPAN=2><FONT SIZE=+1>" + hardware +
                "</FONT></TD></TR>\n");
        if (software != null) out.print(    
            "<TR><TD COLSPAN=2><FONT SIZE=+1>" + software +
                "</FONT></TD></TR>\n");
        out.println ("</TABLE>");
	// Warning during SPEC development. Remove before customer ship
	out.println ("Sample reporting page for SPEC members' internal use only");
	out.println (graphTable);
	out.print(
	    "<P>\n");
        DataInputStream in = new DataInputStream(
            new BufferedInputStream( new FileInputStream(template)));
        TableGroup m = new TableGroup(in,props);
        out.println(m.toString());
	out.println(metrics.detail());
	if (useJavaGraph)
	   out.println (metrics.javaDetail(codeBase));
	if (issue != null && ! issue.equals(""))
	    out.print("<HR><FONT SIZE=-1><I>\n" +
		"Published in the " + issue + " SPEC Newsletter<br>\n" +
		"(C) Copyright SPEC, 1997. All rights reserved\n" +
		"</I></FONT>\n");
	listProperties (out);
        out.print(
            "</BODY></HTML>\n");
        out.close();
    }catch (Exception e){
        spec.harness.Context.out.println("Error: " + e);
        e.printStackTrace();
    }
}

}

