/*
 * @(#)PropUtils.java	1.2 97/08/26
 * Copyright (c) 1997 Sun Microsystems, Inc. All rights reserved
 */

package spec.reporter;

import java.io.*;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class PropUtils{

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////

///////////////////////////////////////
//class method declarations
///////////////////////////////////////

public static void main (String[] args){
    Properties p = loadMail ("in1");
    Properties s = loadFile ("in2");
    merge (p,s);
    if (p != null)
	p.list(spec.harness.Context.out);
}

private static Properties load (InputStream in) throws IOException {
    Properties p = new Properties();
    p.load(in);
    return p;
}

public static Properties loadFile (String name){
    Properties p = null;
    try{
	p = load (new BufferedInputStream(new FileInputStream (name)));
    }catch (Exception e){
        spec.harness.Context.out.println("Error loading properties: " + e);
    }
    return p;
}

public static Properties loadMail (String name){
    Properties p = new Properties();
    try{
	DataInputStream in = new DataInputStream(
	    new BufferedInputStream(new FileInputStream (name)));
	String line;
	while ((line = in.readLine()) != null){
	    if (line.startsWith("#")) continue;
	    int i = line.indexOf('=');
	    if (i < 0) continue;
	    String key = line.substring (0,i);
	    String value = line.substring (i+1);
	    p.put (key,value);
	}
    }catch (Exception e){
        spec.harness.Context.out.println("Error loading properties: " + e);
    }
    return p;
}

public static Properties loadUrl (String urlString){
    Properties p = null;
    try{
    	URL url = new URL(urlString);
        p = load (new BufferedInputStream( url.openStream() ));
    }catch (Exception e){
        spec.harness.Context.out.println("Error loading properties: " + e);
    }
    return p;
}

public static void merge(Properties primary, Properties secondary){
    if (secondary == null)
	return;
    if (primary == null){
	primary = secondary;
	return;
    }
    for (Enumeration e = secondary.propertyNames(); e.hasMoreElements();){
        String name = (String) e.nextElement();
        String value = secondary.getProperty(name,"");
	if (primary.getProperty(name) == null)
	    primary.put(name,value);
    }
}

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

}

