/*
 * @(#)FileOutputStream.java
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

package spec.io;
import spec.harness.Context;

/**
 * Dummy output stream that is only used as a place holder and for a little
 * benchmark validity checking
 */ 
public class FileOutputStream extends java.io.OutputStream {

    /**
     * Development debug flag
     */
    final static boolean debug = false;
    
    /**
     * Count of bytes written
     */
    static int byteCount = -99999999;
    
    /**
     * Checksum
     */
    static int checksum = 0;

    /** 
     * Standard constructor
     */
    public FileOutputStream(String name) throws java.io.IOException{
    }
  
    /** 
     * Standard constructor
     */
    public FileOutputStream(String name, boolean append) throws java.io.IOException {
    }

    /** 
     * Standard constructor
     */
    public FileOutputStream(spec.io.File file) throws java.io.IOException {
    }
 
    /** 
     * Write a byte
     */
    public void write(int b) throws java.io.IOException {   
	 byteCount++;
	 checksum += specialTrace("W", b ); 
    }

    /** 
     * Write a byte array
     */
    public void write(byte b[]) throws java.io.IOException {
	int len = b.length;    
	byteCount += len;
	if (len > 0) {
   	    checksum += specialTrace("X", b[0] );; // Just checksum the first character
	}	
	if( debug ) {
            System.out.println("Inside spec.io.FileOutStream.write() -- throwing away output");
	}
    }

    /** 
     * Write a byte array
     */
    public void write(byte b[], int off, int len) throws java.io.IOException {
	byteCount += len;

	if (len > 0) {
   	    checksum += specialTrace("Z",b[off]); // Just checksum the first character
	}	
	if( debug ) {    
            System.out.println("Inside spec.io.FileOutStream.write() -- throwing away output");
	}
    }
    
    /** 
     * Chear the byte counter
     */    
    public static void clearCount() {
	byteCount = 0;
	checksum  = 0;
    }

    /** 
     * Print the byte counter in validity chech mode '1'
     */


    public static void printCount(boolean check) {
        spec.io.PrintStream s = (spec.io.PrintStream)Context.out;
        if( check ) {
  	    s.println('1',"File output byte count = "+byteCount+" checksum = "+checksum);
        } else {  	
  	    s.println('1',"File output byte count = "+byteCount);
  	}
    }
    

    public static int specialTrace(String rtn, int ch) {
//	((spec.io.PrintStream)Context.out).println('1',rtn+ch);
	return ch;
    }    
}
  
		      
