/*
 * @(#)SpecJava.java	1.54 02/20/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 */

package spec.harness;

import java.awt.*;
import java.applet.*;
import java.net.*;
import java.io.*;
import java.util.*;

///////////////////////////////////////////////////////////////////////
////////////////////////BEGIN SPECJAVA CLASS///////////////////////////
/////////////////////////////////////////////////////////////////////// 
// specjava class
// The specjava class defines the harness environment within which various
// benchmarks are executed.  It displays results, generates reports, and
// creates an interface to choose benchmarks for execution.

public class SpecJava implements BenchmarkDone {

    static String version = "V99 Harness: 9999-99-99";
    private String compliantGroup;

    Applet applet;
    boolean running = false;    
    boolean autoRun = false;
    boolean testMode = false;
    int percentTimes100 = 200;

    public SpecJava() {
    }

    ///////////////////////// EVENT METHODS /////////////////////////
    /////////////////////////////////////////////////////////////////

    // Generate the report frame

    void reportButton_Clicked(Event event) {
	if (!interactive || props.isSetup()){
	    new ReportFrame( 
                         "SpecJava", 
                         runResults, 
			 props,
                         (standalone) ? "localhost"
				      : applet.getCodeBase().getHost(),
			 interactive
                	   ).show();
	}else{
	    textarea.appendText("You must first press the 'Setup' button\n");
	}
    }


    static String fileColon = "file:///";

    String getCbase() {
        if (!standalone) {
            return applet.getCodeBase().toString();
        } else {
            return fileColon + (new File("")).getAbsolutePath().replace('\\','/');
        }
    }


    // Generate Setup Frame 
    void setupButton_Clicked(Event event) {
	props.setup();
    /*
     *this can never happen now
	if (props.parametersChosen())
	    props.setup();
	else
	    textarea.appendText("You must first answer the parameter file selection dialogue\n");
     */
    }


    void startButton_Clicked( Event event ) {
        selectedBenchmarks = benchlist.getSelectedItems();           		        
        if (selectedBenchmarks.length == 0) {
            spec.harness.Context.out.println("No Benchmarks Selected");
        } else {
            end = false;
            totalaverage = 0;
            running_selection = 0;

            textarea.appendText("--------------------------------\n");
	    Context.setSpeed( Integer.parseInt( speedlist.getSelectedItem() ) );
	    Context.setCachedInputFlag( cachelist.getSelectedItem().equals( "Cache On" ) );
	    running = true;
            handleStart(running_selection);
        }
    }


    void stopButton_Clicked(Event event) {
	running = false;
        if (runner != null) {
            runner.stopBenchmark();
            startButton.enable();
            benchlist.enable();
            grouplist.enable();
//            averagetime = 0;	// unused
            spec.harness.Context.out.println("Benchmark Manually Stopped.");
            System.gc();
        }
    }


    void deselectAll() { 
	for( int i = 0 ; i < benchlist.countItems() ; i++ ) {
	    benchlist.deselect(i);
	}
    }

    void selectAll() { 
	deselectAll(); // Seems to solve some bug
	for( int i = 0 ; i < benchlist.countItems() ; i++ ) {
	    benchlist.select(i);
	}
    }
  
    void selectAllButton_Clicked(Event event) {    
	if ( (selectAllButton.getLabel()).equals("Select All") ){
	    selectAllButton.setLabel("Unselect All");
	    selectAll();
        } else {
	    selectAllButton.setLabel("Select All");
	    deselectAll();
        }
    }

    // Help function -wnb
    void helpButton_Clicked(Event event) {    
	helpActive = true;
	helpButton.setLabel(">>help<<");
    }

    void viewButton_Clicked(Event event) {    
	if ( (viewButton.getLabel()).equals("Console On") ){
	    viewButton.setLabel("Console Off");
	    Context.startOutputWindow();
        } else {
	    viewButton.setLabel("Console On");
	    Context.stopOutputWindow();
        }
    }


    void autoRunButton_Clicked(Event event) { 
	autoRun = true;	
	startButton_Clicked( event );		
    }


    // User clicked start button
    void handleStart(int choice) {
        startButton.disable();
        benchlist.disable();
        grouplist.disable();
        runProgram( selectedBenchmarks[choice] );
    }


    public void start() {
//**NS**        if (runner != null)
//**NS**            runner.resume();
    }


    public void stop() {
//**NS**        if (runner != null)
//**NS**            runner.suspend();
    }

    // Help function -wnb
    private boolean handleHelpEvent (Event event) {
        if (event.id == Event.LIST_SELECT){
            int n = ((Integer)(event.arg)).intValue();
            if (n < benchlist.countItems()){
                showHelp ((String) props.get("spec.help.benchmarks") + "/" +
		    benchlist.getItem(n) + ".html");
                benchlist.deselect(n);      // undo action not desired for help
                return true;
            }
        }else if (event.id == Event.LIST_DESELECT){
            int n = ((Integer)(event.arg)).intValue();
            if (n < benchlist.countItems()){
                showHelp((String) props.get("spec.help.benchmarks") + "/" +
		    benchlist.getItem(n) + ".html");
                benchlist.select(n);        // undo action not desired for help
                return true;
            }
        }else if (event.id == Event.ACTION_EVENT){
            if (event.target instanceof Button){
                Button b = (Button) event.target;
                showHelp((String) props.get ("spec.help.Button." + 
		    b.getLabel().replace(' ','_')));
                return true;
	    /*
	     * Turn off help for Choice items until I get a good way
	     * to undo the state change selecting them causes
	     * -walter
            }else if (event.target instanceof Choice){
                Choice c = (Choice) event.target;
                showHelp((String) props.get ("spec.help.Choice." + 
		    c.getSelectedItem().replace(' ','_')));
                return true;
	     *
	     */
            }
        }
        return false;
    }

    // Help function -wnb
    private void showHelp (String s){
	try{
	    URL u = new URL(getCbase() + s);
	    if (showHelpInBrowser)
	        applet.getAppletContext().showDocument (u, "help");
	    else{
		DataInputStream in = new DataInputStream(
		    new BufferedInputStream(u.openStream()));
		System.out.println("--- HELP: " + s + " ---");
		String line;
		while ((line = in.readLine()) != null)
		    if (! line.startsWith("<"))
		        System.out.println(line);
	    }
	}catch (Exception e){
	    System.out.println("showHelp: " + e);
	}
    }

    // HANDLEEVENT
    public boolean handleEvent(Event event) {

	// Help function -wnb
	if (helpActive && handleHelpEvent(event)){
	    helpActive = false;
	    helpButton.setLabel("Help");
	    return true;
	}

        if (event.target == grouplist && event.id == Event.ACTION_EVENT){
            setBenchmarkList( (String)event.arg );
            return true;
        }

	// Help function -wnb
        if (event.target == helpButton && event.id == Event.ACTION_EVENT) {
            helpButton_Clicked(event);
            return true;
        }

        if (event.target == startButton && event.id == Event.ACTION_EVENT) {
            startButton_Clicked(event);
            return true;
        }

        if (event.target == stopButton && event.id == Event.ACTION_EVENT) {
            stopButton_Clicked(event);
            return true;
        }
	if (event.target == selectAllButton && event.id == Event.ACTION_EVENT) {
            selectAllButton_Clicked(event);
            return true;
        }
	
	if (event.target == autoRunButton && event.id == Event.ACTION_EVENT) {
             autoRunButton_Clicked(event);
            return true;
        }	

        if (event.target == setupButton && event.id == Event.ACTION_EVENT) {
            setupButton_Clicked(event);
            return true;
        }

        if (event.target == reportButton && event.id == Event.ACTION_EVENT) {
            reportButton_Clicked(event);
            return true;
        }

        if (event.target == viewButton && event.id == Event.ACTION_EVENT) {
            viewButton_Clicked(event);
            return true;
        }


        if (event.target == quitButton && event.id == Event.ACTION_EVENT) {
            System.exit(0);
            return true;
        }

/* For initial dialog */

        if (event.target == initialButton && event.id == Event.ACTION_EVENT) {
	    showHelpInBrowser = helpWhere.getCurrent().getLabel().equals("browser");
    	    testMode = runType.getCurrent().getLabel().equals("test");
            storeProperties();
            return true;
	}

        if (event.target == initialHelpButton && event.id == Event.ACTION_EVENT) {
	    showHelpInBrowser = helpWhere.getCurrent().getLabel().equals("browser");
	    System.out.println(
		"\nIf you are running in a web browser, e.g. Netscape Navigator,\n" +
		"Internet Explorer, or HotJava, you may display help information\n" +
		"in a new browser window for convenience in reading and navigating\n"+
		"the topics, by checking the appropriate button in the initial\n" +
		"SPECjava window. Otherwise help information will be displayed in\n" +
		"your Java console like this message.\n");
	    showHelp((String) props.get ("spec.help.initial"));
            return true;
	}

        if (event.target == checkTypeCompliant && event.id == Event.ACTION_EVENT) {
            grouplist.select(compliantGroup);
            setBenchmarkList(compliantGroup);
	    cachelist.select("Cache On");
            grouplist.disable();
	    cachelist.disable();
            return true;
	}
        if (event.target == checkTypeTest && event.id == Event.ACTION_EVENT) {
            grouplist.enable();
	    cachelist.enable();
            return true;
	}

        if (event.target == cancelButton && event.id == Event.ACTION_EVENT) {
            System.exit(0);
            return true;
        }

        return false;
    }



    void loadBenchmarkGroups() {
	for( int i = 1 ;; i++ ) {  	
	    String s = props.get("spec.benchmarkGroup"+i+".00");
	    if( s == null )
	        return;	    
	    Vector v = new Vector();
	    v.addElement( s );	    
		    	    
	    for( int j = 1 ;; j++ ) {			    
		s = props.get("spec.benchmarkGroup"+i+"."+((j < 10) ? "0" : "") + j);
		if( s == null )
		    break;  
		v.addElement( s );
	    }	    
	    benchmarkGroups.addElement( v );
	}	
    }




    void setBenchmarkList( String s ) {
	benchlist.clear();
	for( int i = 0 ; i < benchmarkGroups.size() ; i++ ) {
	    Vector x = (Vector)benchmarkGroups.elementAt( i );
	    if( s.equals( x.elementAt( 0 ) ) ) {
		for( int j = 1 ; j < x.size() ; j++ ) {
		    benchlist.addItem( (String)x.elementAt( j ) );     
		}
	    }
	}
    }
    


    // INIT Method
    public void init( Applet applet, boolean standalone ) {
        this.applet      = applet;
        this.standalone  = standalone;	
	Context.setSpecBasePath( getCbase() );
	props = new SpecProps( getCbase(), c6 );
	compliantGroup = props.get ("spec.initial.compliant.group","All");
	String percentString = (String)props.get( "spec.initial.percentTimes100" );
	percentTimes100 = Context.getValue( percentString, 200 );
        if( props.get("spec.initial.console").equals("true") ) {
            Context.setupConsoleWindow();
        }
	loadBenchmarkGroups();		
	version = props.get("spec.report.version.ro")+" Harness: "+props.get("spec.report.versionDate.ro");
	// Command line or applet parameter settings show up in the
	// Context object. These settings override properties settings
	// in the user file if you choose batch (non-interactive) mode.
	// Otherwise run interactive unless the property exists and
	// is false
	String si = (String) props.get ("spec.initial.interactive");
	if (Context.isBatch() || (si != null && si.equalsIgnoreCase ("false")))
	    interactive = false;
	initialDialog();
        if (!interactive){
	    String size = props.get ("spec.initial.default.size","100");
            String group = props.get ("spec.initial.default.group",
		compliantGroup);
	    testMode = ! (group.equals(compliantGroup) && size.equals("100"));
            storeProperties();
            grouplist.select (group);
            setBenchmarkList (group);
	    speedlist.select (size);
	    selectAll();
    	    autoRunButton_Clicked((Event) null);
	}
    }


    public void initPart2() {
    
	applet.hide();
	applet.removeAll();

        applet.setBackground(c6);
	Font helveticaBold14 = new Font("helvetica", Font.BOLD,14);
	if (!standalone)
            applet.showStatus(SpecJava.version);

	/*
	The main division of the window is left/right.  On the left
	side is a scrolling list of available benchmarks to run. This
	list extends the full height of the window. In test mode the
	user may select any or all of the benchmarks. In SPEC-compliant
	measured run mode all benchmarks are selected and the user may
	not modify the selection.  We hope this list can be tall enough
	to contain all the benchmarks finally included by SPEC so that
	the user need not scroll the list to see any benchmark.
	*/

	applet.setLayout (new BorderLayout());
	Panel leftPanel = new Panel();
	leftPanel.setLayout (new BorderLayout());
	Label leftPanelLabel = new Label ("Benchmarks:");
	leftPanelLabel.setFont (helveticaBold14);
	leftPanel.add ("North",leftPanelLabel);
	leftPanel.add ("Center",benchlist);
	applet.add ("West",leftPanel);
	if (!testMode){
	    selectAll();
	    benchlist.disable();
	}

	/*
	The right of the window is split top/bottom At the top is a
	text display area.  used for informational display messages
	from the SPECjava program to the benchmark user.
	*/

	Panel rightPanel = new Panel();
	rightPanel.setLayout (new FlowLayout());
	Label rightPanelLabel = new Label("Status:");
	rightPanelLabel.setFont (helveticaBold14);
	rightPanel.add (rightPanelLabel);
        textarea = new TextArea (
	    (String) props.get("spec.report.suiteName.ro") + 
	    " DEV - SPEC member use only\n" +
	    SpecJava.version + "\n" +
	    "Press the HELP button, then any button or benchmark\n" +
	    "to display help ", 10, 45);
	if (showHelpInBrowser)
	    textarea.appendText ("in a browser window\n");
	else
	    textarea.appendText ("in your Java console\n");
	if (!testMode){
	    textarea.appendText ("Set to perform SPEC compliant run\n" +
		"Some controls are disabled. To use these or read help\n" +
		"on these items, run in test mode\n");
	}
	if (!interactive){
	    textarea.appendText ("Non-interactive mode selected\n" +
		"Will autorun the default benchmark group and send results\n");
	    if (standalone)
	        textarea.appendText ("and then exit\n");
	}
        textarea.setEditable(false);
	rightPanel.add (textarea);

	/*
	At the bottom of the right portion is an array of buttons and
	choice menu(s) arranged in three columns. These are used to
	control benchmark operation. In test mode all buttons are
	active whereas in SPEC-compliant mode some are inactive
	*/

	Panel buttonPanel = new Panel();
	buttonPanel.setLayout (new GridLayout(0,3,5,3));

	// row 1
	Label buttonLabel = new Label ("Controls:");
	buttonLabel.setFont (helveticaBold14);
	buttonPanel.add (buttonLabel);
        speedlist = new Choice();	
	speedlist.addItem( "1" );
	speedlist.addItem( "10" );
	speedlist.addItem( "100" );
//	speedlist.addItem( "1000" );	NOT NOW, BUT MAYBE LATER
//	speedlist.select( "100" );			
	speedlist.select (props.get ("spec.initial.default.size","100"));			
	buttonPanel.add (speedlist);
        viewButton      = new Button("Console On");
	buttonPanel.add(viewButton);
	if(! props.get("spec.initial.console").equalsIgnoreCase("true") )
	    viewButton.disable();

	// row 2
        stopButton      = new Button("Stop");
	buttonPanel.add(stopButton);
        startButton	= new Button("Start");
	buttonPanel.add(startButton);
	autoRunButton   = new Button("Auto Run");	
	buttonPanel.add(autoRunButton);

	// row 3
        setupButton     = new Button("Setup");
	buttonPanel.add(setupButton);
        reportButton    = new Button("Report");
	buttonPanel.add(reportButton);
	helpButton	= new Button("Help");
	buttonPanel.add(helpButton);

	// row 4
	selectAllButton = new Button("Select All");
	buttonPanel.add(selectAllButton);
	quitButton  = new Button("Quit");
	buttonPanel.add(quitButton);
	if (! standalone)
	    quitButton.disable();
	if (!testMode){
	    speedlist.select( "100" );			
	    speedlist.disable();
	    startButton.disable();
	    selectAllButton.disable();
	}
	rightPanel.add (buttonPanel);
	applet.add ("Center",rightPanel);

    applet.validate();
    applet.show();
    }



    //Convert a package name to a relative directory path.

    String classToPath(String clsname) {
        return getCbase() + (new String(clsname.toCharArray(),0,clsname.lastIndexOf(".")+1)).replace('.','/');
    }




    // We have the name of the class -- now load it and make a ProgramRunner
    // to run it.
    void runProgram(String className) {
	char defaultValidityValue = '0';
	String validityString = props.get( "spec.validity."+className );
	if (validityString != null) {
	    defaultValidityValue = validityString.charAt(0);
	}
	int automin = getIntProp (props, "spec.initial.automin", 1);
	int automax = getIntProp (props, "spec.initial.automax", 20);
	int autodelay = getIntProp (props, "spec.initial.autodelay", 0);
	boolean autogc = getBoolProp (props, "spec.initial.autogc", true);
	boolean doChecksum = getBoolProp (props,
	    "spec.validity.checksum."+className, true);
        runner = new ProgramRunner (
	    className,
	    new String[0],
	    autoRun,
	    this,
	    defaultValidityValue,
	    percentTimes100,
	    automin,
	    automax,
	    autodelay,
	    autogc,
	    doChecksum
	    );
        runner.start();
    }

    private boolean getBoolProp (SpecProps props, String key, boolean value){
        if (props != null){
	    String s = props.get (key);
	    if (s != null){
		if (s.equalsIgnoreCase("true"))
		    return true;
		if (s.equalsIgnoreCase("false"))
		    return false;
	    }
	}
	return value;
    }

    private int getIntProp (SpecProps props, String key, int value){
        if (props != null){
	    String s = props.get (key);
	    if (s != null)
		try{
		    value = Integer.parseInt (s);
		}catch (NumberFormatException e){} // keep default value
	}
	return value;
    }

    public String qualifyFileName(String unqualified) {
        return getCbase() + unqualified;
    }

   
/**
 public void benchmarkDone( long firstTime, String firstStats, long bestTime, String bestStats ) {
	long total_ms = bestTime;
	String bname = selectedBenchmarks[running_selection];
        String filler = "";

        for( int i=0 ; i<30 - bname.length() ; i++ ) {
            filler += " ";
        }

        textarea.appendText( bname + filler + total_ms/1000.0 +" secs\n");
**/

 public void benchmarkPrint( String s ) {
     textarea.appendText( s );
 }

 public void benchmarkDone( String className, Properties results ) {
 
	if( results != null ) {
   	    runResults.put( className, results );	
	}
 
	if( selectedBenchmarks.length > 0 ) {
            if( running_selection < selectedBenchmarks.length - 1 ) {
                running_selection += 1;
                handleStart(running_selection);
                return;
            }
	}
	
        textarea.appendText( SpecJava.version + " Finished\n" );
        
        startButton.enable();
        benchlist.enable();
        grouplist.enable();
	running = autoRun = false;	    
	if (!interactive){
	    reportButton_Clicked ((Event)null);
	    if (standalone)
	        System.exit (0);
	}
    }




    ///////////////////////////////////////////////////////////////////////
    ///////////////////       DECLARATIONS    /////////////////////////////
    // Class Member Declarations
    private Panel panel1,panel2,panel3;
    Button helpButton;    // Help function -wnb
    boolean helpActive = false;
    boolean interactive = true;
    boolean showHelpInBrowser = false;
    Button viewButton;    
    Button startButton;
    Button setupButton;
    Button stopButton;
    Button reportButton;
    Button quitButton;
    Button selectAllButton;
    Button autoRunButton;
    Button initialButton;	// OK in initial dialogue
    Button initialHelpButton;	// Help in initial dialogue
    Button cancelButton;	// Cancel in initial dialogue
    Choice grouplist;
    Choice speedlist;
    Choice cachelist;    
    List benchlist = new List(12,true);	
    TextField textfield;
    TextArea textarea;
    GridBagLayout gridbag = new GridBagLayout();

    Color c1 = new Color(0xfff7f3);
    Color c2 = new Color(0xa1b8c3);  // whole background
    Color c3 = new Color(0xfff7dc);  // each area
    Color c4 = new Color(0x5e6bb1);  // blue
    Color c6 = new Color(0xffffe6);  // light yellow

    int running_selection = 0;
//    float averagetime = 0.0f;       //unused
    float totalaverage = 0.0f;

    boolean end = false;

    ProgramRunner runner; // this runs the chosen program in a separate thread.

/*
    ConfigProp config;		// read user configuration file & present editing dialog
    static Properties props;	// all we know
*/
    SpecProps props;

    Vector   benchmarkGroups    = new Vector();
    String[] selectedBenchmarks = new String[0];

    public  static boolean standalone = false;

    protected int NUM_ITER = 0;


    /** This is a Hashtable where there is an entry for each benchmark. The associated data
    is another Hashtable with all the keys and values that should be placed in the output
    email. It is done this way so that it is easy to remove the results of a previous benchmark
    run */

    Hashtable runResults  = new Hashtable();



/************************************** Initial dialog *************************************/



    TextField[] fields;
    String[] propNames = {
	        "spec.initial.clientFile",
	        "spec.initial.serverFile"
                };    
    CheckboxGroup helpWhere;	// Help function -wnb
    CheckboxGroup runType;
    Checkbox checkTypeCompliant;
    Checkbox checkTypeTest;
    
    /**
    Create the initial window that appears
    The user must enter URL's of property files describing the client
    and server systems, and make other choices regarding benchmark
    operation. Sketch of screen showing use of panels p1..p9:

   /------------------\
   |WARNINGS - NOTICES| p1
   \------------------/

   /---------------------------------------------\
   |Property files describing your configuration:|
   |___________________________________________  | p2
   |___________________________________________  |
   \---------------------------------------------/
   /----------------------------------------------------------\
   |Type of run:                                              |
   | /----------------------------------------------------\   |
   | |* SPEC compliant  /---------------------------\     |   |
   | |     p10          |* test mode  p11           |     |   |
   | |                  |/---------------------\    |     |   |
   | |                  ||Benchmark set: [[[]]]| p3 |     |   |
   | |                  |\---------------------/    | p5  |p6 | p7
   | |                  |/---------------------\    |     |   |
   | |                  ||Input files:   [[[]]]| p4 |     |   |
   | |                  |\---------------------/    |     |   |
   | |                  \---------------------------/     |   |
   | \----------------------------------------------------/   |
   \----------------------------------------------------------/
   /--------------------------------------------\
   | /-------------------------------------\    |
   | |Show help in:  * console   * browser | p8 |
   | \-------------------------------------/    |
   |            /----------------------\        | p12
   |            | [OK] [Help] [Cancel] | p9     |
   |            \----------------------/        |
   \--------------------------------------------/

    */
    void initialDialog() {
	Panel p1 = new Panel();
	Panel p2 = new Panel();
	Panel p3 = new Panel();
	Panel p4 = new Panel();
	Panel p5 = new Panel();
	Panel p6 = new Panel();
	Panel p7 = new Panel();
	Panel p8 = new Panel();
	Panel p9 = new Panel();
	Panel p10 = new Panel();
	Panel p11 = new Panel();
	Panel p12 = new Panel();
	Font helveticaBoldItalic = new Font("helvetica",
	    Font.BOLD+Font.ITALIC, 12);
	applet.setLayout(new FlowLayout());
	applet.setBackground (c6);

	Graphics g = applet.getGraphics();
	g.draw3DRect(30,10,20,50,false);

	// Warnings - notices - from "props/spec"
	p1.setLayout(new GridLayout(0,1));
	for (int i=1; ; i++){
	    Label lbl;
	    String msg = (String) props.get("spec.initial.message" + i);
	    if (msg == null)
		break;
	    lbl = new Label(msg ,Label.CENTER);
	    lbl.setFont (helveticaBoldItalic);
	    p1.add (lbl);
	}
	applet.add (p1);

	// property files describing client and server configurations
	p2.setLayout (new GridLayout (0,1));
	p2.add (new Label("Property files describing your configuration:"));
	fields = new TextField[propNames.length];
	for (int i=0; i<propNames.length; i++){
	    String value = props.get( propNames[i] );
            if (value == null)
		value = "";
	    else
		value = getCbase() + value;
	    fields[i] = new TextField(value,45);
            p2.add(fields[i]);
	}
	applet.add (p2);

	/*
	Now working from inside out, p3 through p7
	Choose whether this is a compliant SPEC run or just a test
	*/

	// Select benchmark set
	p3.add (new Label("Benchmark set:"));
        grouplist = new Choice();
	setBenchmarkList( (String)((Vector)benchmarkGroups.elementAt( 0 )).elementAt( 0 ) );
        for( int i = 0 ; i < benchmarkGroups.size(); i++) {
	    grouplist.addItem( (String)((Vector)benchmarkGroups.elementAt( i )).elementAt( 0 ) );
        }	
        String group = props.get ("spec.initial.default.group","All");
        grouplist.select (group);
        setBenchmarkList (group);
	p3.add (grouplist);
	
	// Select whether input files are cached
	p4.add (new Label("Input files:"));
	cachelist = new Choice();
	cachelist.addItem( "Cache Off" );
	cachelist.addItem( "Cache On" );	
	cachelist.select((Context.isCachedInput() ? "Cache On" : "Cache Off") );
	p4.add (cachelist);

	// Block of controls that go with test mode
	runType = new CheckboxGroup();
	checkTypeTest = new Checkbox("test",runType,true);
	p11.add (checkTypeTest);
	p5.setLayout (new GridLayout (3,1));
	p5.add (p11);
	p5.add (p3);
	p5.add (p4);

	// SPEC compliant or test mode
	p6.setLayout (new GridLayout (1,2));
	checkTypeCompliant = new Checkbox("SPEC compliant",runType,false);
	p10.add (checkTypeCompliant);
	p6.add (p10);
	p6.add (p5);

	// Type of run
	p7.setLayout (new BorderLayout());
	p7.add ("North", new Label ("Type of run:"));
	p7.add ("Center", p6);
	applet.add (p7);

	// Choose where you want help displayed
	p12.setLayout (new GridLayout (2,1));
	p8.add( new Label("Show help in:"));
	helpWhere = new CheckboxGroup();
	p8.add(new Checkbox("console", helpWhere, true));
	p8.add(new Checkbox("browser", helpWhere, false));
	p12.add(p8);

	//Action buttons
	initialButton = new Button("OK");
	initialHelpButton = new Button("Help");
	cancelButton =  new Button("Cancel");
	p9.add(initialButton);
	p9.add(initialHelpButton);
	if (standalone)
	    p9.add(cancelButton);
	p12.add(p9);

	// help and button panel
	applet.add(p12);
    
    }

    private void storeProperties(){
	for (int i=0; i<propNames.length; i++){
	    props.put(propNames[i],fields[i].getText());
        }
	initPart2();
    }






    ///////////////////////   END OF CLASS   //////////////////////////////
    ///////////////////////////////////////////////////////////////////////
    ///////////////////   BEGIN DEBUG METHODS /////////////////////////////

    ////////////////////   END DEBUG METHODS   ////////////////////////////
    ///////////////////////////////////////////////////////////////////////

}

