/*
 * @(#)ReportFrame.java	1.7 02/04/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 */

package spec.harness;

import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.*;


public class ReportFrame extends Frame {

    static String defaultMailee = "walter@pro.specbench.org";
    
    private String getin( DataInputStream in ) {
    
        StringBuffer sb = new StringBuffer();
        
        try {             
            while( in.available() > 0 )
                sb.append( (char)in.read() );            
            } catch( Exception e ) {}          
        
        
        if( sb.length() > 0 ) {            
            spec.harness.Context.out.print( "<<<<" );
            spec.harness.Context.out.print( sb.toString() );
            spec.harness.Context.out.flush();
        }
        
        return sb.toString();
    }


    private void inwait( DataInputStream in, int time ) {
        
        for( int i = 0 ; i < time ; i+= 100 ) {
            try {
                if( in.available() > 0 )
                    return;
                Thread.sleep( 100 );
                } catch( Exception e ) { return; }                    
        }    
    }
        

    private boolean outin( PrintStream out, DataInputStream in, boolean response, String msg ) {    
    
        spec.harness.Context.out.println( "===============================================" );      
    
        getin( in );
    
        out.println( msg );
        spec.harness.Context.out.println( ">>>>" + msg );
        spec.harness.Context.out.flush();
        
        if( response )
            inwait( in, 3000 );
        
        getin( in );
                
        return false;
    }

    void sendClicked(Event event) {
    
	String from = props.get("spec.other.emailReturn");
	if (from == null) from = "Java-benchmark-program";

//spec.harness.Context.out.println("Mailing to: " + actfield.getText() );
       
        Socket s = null;
        PrintStream out = null;
        DataInputStream in = null;
       
        try {
            s   = new Socket( serverName, 25 );
            out = new PrintStream( s.getOutputStream() );
            in  = new DataInputStream( s.getInputStream() );
            
            if( outin( out, in, true,  "HELO "        + serverName ) )           return;
            if( outin( out, in, true,  "MAIL FROM: " + from ) )                  return;
            if( outin( out, in, true,  "RCPT TO: " + actfield.getText() ) )      return;
            if( outin( out, in, true,  "DATA") )                                 return;
            if( outin( out, in, false, "Subject: SpecJava Results" ) )           return;
            if( outin( out, in, false, "To: " + actfield.getText() ) )           return;
            if( outin( out, in, false, "From: " + from) )			 return;           
//	    if( outin( out, in, false, props.toString() ) )			 return;
	    if( outin( out, in, false, results ) )		      	         return;	    
            if( outin( out, in, true,  ".") )                                    return;
            if( outin( out, in, true,  "QUIT") )                                 return;                     

        } catch(Exception e){
            System.err.println("Message Send error: " + e.toString());
        } finally {
            try{ out.close(); } catch( Exception x ) {}
            try{ in.close();  } catch( Exception x ) {}
            try{ s.close();   } catch( Exception x ) {}
            hide();
        }
    }



    void cancelClicked(Event event) {
        hide();
    }


    public synchronized void show() {
        move(50, 50);
        super.show();
	if (!interactive)
    	    sendClicked ((Event) null );
    }

    public boolean handleEvent(Event event) {
        if (event.id == Event.WINDOW_DESTROY) {
            hide();         // hide the Frame
            return true;
        }

        if (event.target == fullBrief && event.id == Event.ACTION_EVENT) {
            fullBriefClicked(event);
            return true;
        }


        if (event.target == send && event.id == Event.ACTION_EVENT) {
            sendClicked(event);
            return true;
        }
	
        if (event.target == cancel && event.id == Event.ACTION_EVENT) {
            cancelClicked(event);
            return true;
        }

        return super.handleEvent(event);
    }


    void fullBriefClicked(Event event) {    
	resetResults( (fullBrief.getLabel()).equals("Full") );
    }


    void resetResults( boolean full ) {
    
	StringBuffer brief = new StringBuffer();
    
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
	
	for( Enumeration e = runResults.elements() ; e.hasMoreElements() ; ) {
	    Properties pp = (Properties)e.nextElement();
	    pp.save( baos, null );
	    for( Enumeration f = pp.keys() ; f.hasMoreElements() ; ) {
  		String key = (String)f.nextElement();
		if( key.endsWith( ".time" ) ) {
		    brief.append( key );
		    brief.append( "=" );
		    brief.append( pp.get( key ) );
		    brief.append( "\n" );
		}
	    }
	}
          
	results = QuickSort.sort( props.toString() + baos.toString(), false );    
	
	textarea.setText(   (full) ? results : QuickSort.sort( brief.toString() ) );
	fullBrief.setLabel( (full) ? "Brief" : "Full" );
	
    }



    public ReportFrame( String title, Hashtable runResults, SpecProps props,
	String srvName, boolean interactive ) {
    
	this.props      = props;
	this.runResults = runResults;
        serverName = srvName;
	this.interactive = interactive;

        addNotify();

        panel1 = new Panel();
        panel1.setLayout(gridbag);
        constraints.constrain(panel1, new Label( SpecJava.version ), 0, 0, 1, 1,
            GridBagConstraints.NONE,GridBagConstraints.CENTER, 0.3, 0.0, 0, 0, 0, 0);

        panel2 = new Panel();
        panel2.setLayout(gridbag);
        textarea = new TextArea(20, 40);
        textarea.setEditable(false);
        textarea.setFont(new Font("Helvetica", Font.BOLD, 12));
        textarea.setBackground(Color.lightGray);

        constraints.constrain(panel2, textarea, 0, 1, 3, 3, GridBagConstraints.HORIZONTAL,
            GridBagConstraints.NORTH, 1.0, 0.0, 0, 0, 0, 0);

	fullBrief = new Button( "????" );

        actlabel = new Label("Mail to ");
/*** switching from various hash tables to SpecProps   
*/
	String emailTo = props.get("spec.other.emailTo");
	if (emailTo == null) emailTo = defaultMailee;
        actfield = new TextField(emailTo);

        panel3 = new Panel();
        panel3.setLayout(gridbag);
/*** NS ***        
        constraints.constrain(panel3, new Label("Report Format  "), 0, 0, 1, 1, GridBagConstraints.NONE,
            GridBagConstraints.EAST, 0.3, 0.0, 0, 0, 0, 0);
        constraints.constrain(panel3, new Label("Submit  "), 2, 0, 1, 1, GridBagConstraints.NONE,
            GridBagConstraints.EAST, 0.3, 0.0, 0, 0, 0, 0);
        constraints.constrain(panel3, choice2, 1, 0, 1, 1, GridBagConstraints.NONE,
            GridBagConstraints.WEST, 0.3, 0.0, 0, 0, 0, 0);
        constraints.constrain(panel3, choice3, 3, 0, 1, 1, GridBagConstraints.NONE,
            GridBagConstraints.WEST, 0.3, 0.0, 0, 0, 0, 0);
*** NS ***/  
        constraints.constrain(panel3, fullBrief, 2, 1, 1, 1, GridBagConstraints.NONE,
            GridBagConstraints.EAST, 0.3, 0.0, 0, 0, 0, 0);          
        constraints.constrain(panel3, actlabel, 3, 1, 1, 1, GridBagConstraints.NONE,
            GridBagConstraints.EAST, 0.3, 0.0, 0, 0, 0, 0);
        constraints.constrain(panel3, actfield, 4, 1, 1, 1, GridBagConstraints.NONE,
            GridBagConstraints.WEST, 0.3, 0.0, 0, 0, 0, 0);

        panel4 = new Panel();
        panel4.setLayout(gridbag);
        constraints.constrain(panel4, send, 0, 1, 1, 1, GridBagConstraints.BOTH,
            GridBagConstraints.CENTER, 0.3, 0.0, 0, 0, 0, 0);
        constraints.constrain(panel4, cancel, 1, 1, 1, 1, GridBagConstraints.BOTH,
            GridBagConstraints.CENTER, 0.3, 0.0, 0, 0, 0, 0);

	resetResults( false );
	
        setTitle("SpecJava Report");
        resize(insets().left + insets().right + 520,insets().top + insets().bottom + 480);

        // Finally, use a GridBagLayout to arrange the panels themselves
        this.setLayout(gridbag);
        this.setBackground(c6);
        constraints.constrain(this, panel1, 0, 0, 1, 1, GridBagConstraints.HORIZONTAL,
            GridBagConstraints.NORTH, 1.0, 0.0, 5, 0, 0, 0);
        constraints.constrain(this, panel2, 0, 1, 1, 1, GridBagConstraints.BOTH,
            GridBagConstraints.NORTH, 1.0, 1.0, 10, 10, 5, 10);
        constraints.constrain(this, panel3, 0, 2, 1, 1, GridBagConstraints.HORIZONTAL,
            GridBagConstraints.NORTH, 1.0, 0.0, 5, 0, 0, 0);
        constraints.constrain(this, panel4, 0, 3, 1, 1, GridBagConstraints.BOTH,
            GridBagConstraints.CENTER, 1.0, 1.0, 10, 10, 5, 10);

    }



    private Font font1,font2;
    private Panel panel1,panel2,panel3,panel4;
    TextArea textarea;
    Label label1;
    Label label2;
    Label actlabel;
    TextField actfield;
    Choice choice1;
    Panel borderPanel1;
    Button button1;
    Button button2;
    Button fullBrief;
    Label label3;
    Choice choice2;
    Choice choice3;
    boolean interactive;
    Label label4;
    Hashtable runResults;
    Button send   = new Button("Send");
    Button cancel = new Button("Cancel");;
    Color c6 = new Color(0xffffe6);  // light yellow

    GridBagLayout gridbag = new GridBagLayout();
    Constraints constraints = new Constraints();
    SpecProps props;
    String results = "";
    String serverName;
}
