/*
 * @(#)QuickSort.java	1.2 02/04/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 */

package spec.harness;

import java.util.*;

public class QuickSort
{

String[] userArray;

public void startSort( String[] userArray )
    {
    this.userArray = userArray;
    
    if( !isAlreadySorted() )
        quicksort( 0, userArray.length-1 );
    }

private void quicksort( int p, int r )
    {
    if( p < r )
        {
        int q = partition( p, r );
        
        if( q == r )
            q--;
        
        quicksort( p, q );
        quicksort( q+1, r );
        } 
    }

private int partition( int lo, int hi )
    {
    String pivot = userArray[lo];
    
    while (true)
        {
        while( compare( userArray[hi], pivot ) >= 0 && lo < hi )
            hi--;
            
        while( compare( userArray[lo], pivot ) <  0 && lo < hi )
            lo++;
            
        if( lo < hi )
            {
            String      T = userArray[lo];
            userArray[lo] = userArray[hi];
            userArray[hi] = T;
            }
        else
            return hi;            
        } 
    } 


private boolean isAlreadySorted()
    {
    for( int i=1 ; i < userArray.length ; i++ )
        {
        if( compare( userArray[i], userArray[i-1] ) < 0 )
            return false;
        }
        
    return true;    
    }
  

public int compare( String a, String b )  
    {
    return a.compareTo( b );
    }



public static String[] sort( String[] args )
    {
    QuickSort q = new QuickSort();
    q.startSort( args );
    return q.userArray;
    }


public static String sort( String text, boolean comments )
    {
    Vector v = new Vector();
    
    for( StringTokenizer st = new StringTokenizer( text, "\n", false ) ; st.hasMoreElements() ; )    
        v.addElement( st.nextElement() );

    String[] sa = new String[v.size()];
    v.copyInto( sa );
    sa = sort( sa );

    StringBuffer sb = new StringBuffer();
    for( int i = 0 ; i < sa.length ; i++ )
        {
	if( comments == true || sa[i].charAt( 0 ) != '#' )
	    {
            sb.append( sa[i] );
	    sb.append( "\n" );        
	    }
        }

    return sb.toString();
    }
    

public static String sort( String text )
    {    
    return sort( text, true );
    }        
    
}


