/*
 * @(#)OrderedProperties.java	1.3 02/04/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 */

package spec.harness;

import java.io.*;
import java.util.Properties;
import java.util.Vector;

public class OrderedProperties extends Properties{

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////
private Vector sequence = new Vector();

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////

///////////////////////////////////////
//class method declarations
///////////////////////////////////////

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

public Object keyAt (int i){
    return sequence.elementAt(i);
}

public void load (InputStream in) throws IOException{
    DataInputStream din = new DataInputStream(in);
    String line;
    while ((line = din.readLine()) != null){
	if (line.startsWith("#")) continue;
	int i = line.indexOf('=');
	if (i < 0) continue;
	String key = line.substring(0,i);
	String value = line.substring(i+1);
	if (get(key) == null)	// don't duplicate keys in sequence
	    sequence.addElement(key);
	super.put (key,value);	// put initial/updated value in any case
    }
}

public int size(){
    return sequence.size();
}

public Object valueAt (int i){
    return get(sequence.elementAt(i));
}



}

