/*
 * @(#)Dialog2Card.java	1.6 02/04/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 */

package spec.harness;

import java.awt.*;
import java.util.Properties;

public class Dialog2Card extends Panel{

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////
Properties titleProps;
Properties valueProps;
String[] propNames;
TextField[] fields;
int indexFrom;
int indexTo;
int colWidth;

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////
Dialog2Card(Properties t, Properties v, String[] pn, 
    TextField[] textFields, int iFrom, int iTo, int cw){
    titleProps = t;
    valueProps = v;
    propNames = pn;
    fields = textFields;
    indexFrom = iFrom;
    indexTo = iTo;
    colWidth = cw;
    Panel innerPanel = new Panel();
    innerPanel.setLayout(new GridLayout(0,2));
    for (int i=iFrom; i<iTo; i++){
	String label = titleProps.getProperty(propNames[i]);
	if (label == null) label = "label " + i + " missing";
	innerPanel.add(new Label(label));
	fields[i] = new TextField("uninitialized",colWidth);
	innerPanel.add(fields[i]);
    }
    add (innerPanel);
    resetValues();
}

///////////////////////////////////////
//class method declarations
///////////////////////////////////////
public void resetValues(){
    for (int i=indexFrom; i<indexTo; i++){
	String value = valueProps.getProperty(propNames[i]);
	if (value == null) value = "";
	if (fields[i] == null)
	    spec.harness.Context.out.println("Error. Text field null: " + i);
	else
	    fields[i].setText(value);
    }
}

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

}
