/*
 * @(#)Dialog2.java	1.6 02/04/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 */

package spec.harness;

import java.awt.*;
import java.util.Properties;

public class Dialog2 extends Frame{

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////
Font helvetica12 = new Font ("helvetica",Font.PLAIN,12);

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////
String title;
Properties titleProps;
Properties valueProps;
String[] propNames;
TextField[] fields;
int colWidth;
int nrow;
Dialog2Card[] cards;
CardLayout cardLayout;
Panel cardPanel;
public boolean statusOK = false;

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////
Dialog2(String ttl, Properties t, Properties v, String[] pn, 
    int cw, int maxRows, Color backgroundColor){
    title = ttl;
    titleProps = t;
    valueProps = v;
    propNames = pn;
    colWidth = cw;
    setFont (helvetica12);
    int screenSize = Toolkit.getDefaultToolkit().getScreenSize().height;
    int height = getFontMetrics(helvetica12).getHeight();
    int nrow = (int)((screenSize - insets().top - insets().bottom)
	* 0.4 / height) - 1;
    if (nrow > maxRows)		// allow property to override
	nrow = maxRows;		// in case calculation is wrong
    setBackground (backgroundColor);
    setLayout(new BorderLayout());   
    setTitle(title);
    fields = new TextField[propNames.length];
    cardPanel = new Panel();
    cardLayout = new CardLayout();
    cardPanel.setLayout(cardLayout);
    int nCards = (pn.length + nrow - 1)/ nrow;
    cards = new Dialog2Card[nCards];
    int iCard, iFrom;
    for (iCard=0, iFrom=0; iCard < nCards; iCard++){
        int iTo = Math.min(iFrom + nrow, propNames.length);
        cards[iCard] = new Dialog2Card(t, v, propNames, fields,
        iFrom, iTo, cw);
        cardPanel.add("Page " + iCard + " of " + nCards,cards[iCard]);
        iFrom += nrow;
    }
    add("Center",cardPanel);
    Panel buttonPanel = new Panel();
    buttonPanel.setLayout(new FlowLayout());
    buttonPanel.add(new Button("Previous"));
    buttonPanel.add(new Button("Next"));
    buttonPanel.add(new Button("OK"));
    buttonPanel.add(new Button("Cancel"));
    add("South",buttonPanel);
    pack();
    show();
}


///////////////////////////////////////
//class method declarations
///////////////////////////////////////

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

public boolean action(Event evt, Object arg){
    if (evt.target instanceof Button){
        if (arg.equals("OK")){
            storeProperties();
	    statusOK = true;
            hide();
        }else if (arg.equals("Cancel")){
	    resetValues();
            hide();
        }else if (arg.equals("Previous")){
            cardLayout.previous(cardPanel);
        }else if (arg.equals("Next")){
            cardLayout.next(cardPanel);
        }
        return true;
    }
    return super.action(evt,arg);
}

public void resetValues(){
    int iCard, iFrom;
    for (iCard=0, iFrom=0; iCard < cards.length; iCard++){
        int iTo = Math.min(iFrom + nrow, propNames.length);
        cards[iCard].resetValues();
        iFrom += nrow;
    }
}

private void storeProperties(){
    for (int i=0; i<propNames.length; i++){
        valueProps.put(propNames[i],fields[i].getText());
    }
}

}

