/*
 * @(#)Constraints.java	1.2 02/04/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 */

package spec.harness;

import java.awt.*;
import java.applet.*;
import java.net.*;
import java.io.*;
import java.util.*;


public class Constraints {
                   
    public void constrain(
                           Container container,
                           Component component, 
                           int grid_x,
                           int grid_y,
                           int grid_width,
                           int grid_height,
                           int fill,
                           int anchor,
                           double weight_x,
                           double weight_y,
                           int top,
                           int left,
                           int bottom,
                           int right
                         ) {
        
        GridBagConstraints c = new GridBagConstraints();
        
        c.gridx = grid_x; 
        c.gridy = grid_y;
        
        c.gridwidth = grid_width; 
        c.gridheight = grid_height;
        
        c.fill = fill; 
        c.anchor = anchor;
        
        c.weightx = weight_x; 
        c.weighty = weight_y;
        
        if (top+bottom+left+right > 0)
            c.insets = new Insets(top, left, bottom, right);
                    
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        
        container.add(component);
        
    }
    
        
    public void constrain(
                           Container container,
                           Component component, 
                           int grid_x,
                           int grid_y,
                           int grid_width,
                           int grid_height
                         ) {
        
        constrain(
                   container,
                   component,
                   grid_x,
                   grid_y, 
                   grid_width,
                   grid_height,
                   GridBagConstraints.NONE, 
                   GridBagConstraints.NORTHWEST,
                   0.0,
                   0.0,
                   0,
                   0,
                   0,
                   0
                 );        
    }
    
        
    public void constrain(
                           Container container,
                           Component component, 
                           int grid_x,
                           int grid_y,
                           int grid_width,
                           int grid_height,
                           int top,
                           int left,
                           int bottom,
                           int right
                         ) {
        
        constrain(
                   container,
                   component,
                   grid_x,
                   grid_y, 
                   grid_width,
                   grid_height,
                   GridBagConstraints.NONE, 
                   GridBagConstraints.NORTHWEST, 
                   0.0,
                   0.0,
                   top,
                   left,
                   bottom,
                   right
                 );
        
    }
    
}

